/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.toolsmiths.validation.profile.Activator;
import org.eclipse.papyrus.toolsmiths.validation.profile.checkers.ProfilePluginCheckerService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ValidateProfilePluginHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || !(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        try {
            new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                monitor.beginTask("Validate Profiles", structuredSelection.size());
                for (Object selectedElement : structuredSelection.toList()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (selectedElement instanceof IProject) {
                        IProject project = (IProject)selectedElement;
                        ProfilePluginCheckerService.checkProfilePlugin(project, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                    SubMonitor.done((IProgressMonitor)monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }
}

