/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.architecture.internal.checkers;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureCommandUtils;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureSwitch;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.gmfdiag.representation.util.RepresentationSwitch;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class ArchitectureDependencies {
    private final String hostBundle;

    ArchitectureDependencies(IProject project) {
        this.hostBundle = PluginRegistry.findModel((IProject)project).getBundleDescription().getSymbolicName();
    }

    Set<String> computeDependencies(Resource resource) {
        return new DependenciesSwitch().doSwitch(resource);
    }

    final class DependenciesSwitch
    extends ComposedSwitch<Set<String>> {
        private static final String BUNDLECLASS_SCHEME = "bundleclass";
        private final Set<String> result = new HashSet<String>();

        DependenciesSwitch() {
            this.addSwitch(this.createArchitectureSwitch());
            this.addSwitch(this.createDiagramSwitch());
        }

        void collectIconDependency(EObject owner, String iconURI) {
            if (iconURI == null) {
                return;
            }
            try {
                ResourceSet rset = owner.eResource().getResourceSet();
                URI uri = rset.getURIConverter().normalize(URI.createURI((String)iconURI));
                this.getBundleName(uri).filter(Predicate.not(ArchitectureDependencies.this.hostBundle::equals)).ifPresent(this.result::add);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private Optional<String> getBundleName(URI uri) {
            Optional<String> result = uri.isPlatformPlugin() || uri.isPlatformResource() ? Optional.of(uri.segment(1)) : (BUNDLECLASS_SCHEME.equals(uri.scheme()) && uri.hasAuthority() ? Optional.of(uri.authority()) : Optional.empty());
            return result;
        }

        void collectCommandDependency(EObject owner, EStructuralFeature feature) {
            Optional<String> bundleName;
            Object commandClass = ArchitectureCommandUtils.getCommandClass((EObject)owner, (EStructuralFeature)feature);
            if (commandClass instanceof Class) {
                Bundle bundle = FrameworkUtil.getBundle((Class)((Class)commandClass));
                bundleName = Optional.ofNullable(bundle).map(Bundle::getSymbolicName);
            } else if (commandClass instanceof IType) {
                Optional<IPluginModelBase> plugin = Optional.empty();
                IType commandType = (IType)commandClass;
                if (commandType.isBinary()) {
                    IPackageFragmentRoot jar = (IPackageFragmentRoot)commandType.getAncestor(3);
                    if (jar != null) {
                        IPath jarPath = jar.getPath();
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(jarPath);
                        if (file != null && file.isAccessible()) {
                            plugin = Optional.ofNullable(PluginRegistry.findModel((IProject)file.getProject()));
                        } else {
                            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getExternalModels();
                            int n = iPluginModelBaseArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IPluginModelBase next = iPluginModelBaseArray[n2];
                                Path path = new Path(next.getInstallLocation());
                                if (jarPath.equals((Object)path) || path.isPrefixOf(jarPath)) {
                                    plugin = Optional.of(next);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                } else {
                    plugin = Optional.of(((IType)commandClass).getJavaProject()).map(IJavaProject::getProject).map(PluginRegistry::findModel);
                }
                bundleName = plugin.map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName);
            } else {
                bundleName = Optional.empty();
            }
            bundleName.filter(Predicate.not(ArchitectureDependencies.this.hostBundle::equals)).ifPresent(this.result::add);
        }

        public Set<String> defaultCase(EObject object) {
            object.eContents().forEach(arg_0 -> ((DependenciesSwitch)this).doSwitch(arg_0));
            return this.result;
        }

        Set<String> doSwitch(Resource resource) {
            resource.getContents().forEach(arg_0 -> ((DependenciesSwitch)this).doSwitch(arg_0));
            return this.result;
        }

        private Switch<Set<String>> createArchitectureSwitch() {
            return new ArchitectureSwitch<Set<String>>(){

                public Set<String> caseADElement(ADElement object) {
                    DependenciesSwitch.this.collectIconDependency((EObject)object, object.getIcon());
                    return null;
                }

                public Set<String> caseArchitectureContext(ArchitectureContext object) {
                    DependenciesSwitch.this.collectCommandDependency((EObject)object, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS);
                    DependenciesSwitch.this.collectCommandDependency((EObject)object, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS);
                    return null;
                }
            };
        }

        private Switch<Set<String>> createDiagramSwitch() {
            return new RepresentationSwitch<Set<String>>(){

                public Set<String> casePapyrusDiagram(PapyrusDiagram object) {
                    DependenciesSwitch.this.collectIconDependency((EObject)object, object.getGrayedIcon());
                    DependenciesSwitch.this.collectCommandDependency((EObject)object, (EStructuralFeature)RepresentationPackage.Literals.PAPYRUS_DIAGRAM__CREATION_COMMAND_CLASS);
                    return null;
                }
            };
        }
    }
}

