/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.helpers.BundleResourceURIHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Messages;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusPluginBuilder;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GenericEMFModelBuilder
extends AbstractPapyrusBuilder {
    private BundleResourceURIHelper RESOURCE_HELPER = BundleResourceURIHelper.INSTANCE;
    private static final String XMLNS = "xmlns";
    private static final Collection<String> EXCLUDED_FOLDER_NAME = new ArrayList<String>();
    private static final Collection<String> EXCLUDED_FILE_NAME = new ArrayList<String>();
    private static final Collection<String> EXCLUDED_FILE_EXTENSION = new ArrayList<String>();
    private static final Collection<String> IGNORED_NS_URI = new ArrayList<String>();

    static {
        EXCLUDED_FOLDER_NAME.add(".settings");
        EXCLUDED_FOLDER_NAME.add("META-INF");
        EXCLUDED_FOLDER_NAME.add("OSGI-INF");
        EXCLUDED_FOLDER_NAME.add("icons");
        EXCLUDED_FOLDER_NAME.add("images");
        EXCLUDED_FOLDER_NAME.add("bin");
        EXCLUDED_FOLDER_NAME.add("target");
        EXCLUDED_FILE_NAME.add(".classpath");
        EXCLUDED_FILE_NAME.add(".project");
        EXCLUDED_FILE_NAME.add(".gitignore");
        EXCLUDED_FILE_NAME.add("about.html");
        EXCLUDED_FILE_NAME.add("build.properties");
        EXCLUDED_FILE_NAME.add("plugin.xml");
        EXCLUDED_FILE_NAME.add("pom.xml");
        EXCLUDED_FILE_NAME.add("README");
        EXCLUDED_FILE_EXTENSION.add("png");
        EXCLUDED_FILE_EXTENSION.add("jpg");
        EXCLUDED_FILE_EXTENSION.add("jpeg");
        EXCLUDED_FILE_EXTENSION.add("gif");
        EXCLUDED_FILE_EXTENSION.add("xml");
        EXCLUDED_FILE_EXTENSION.add("md");
        EXCLUDED_FILE_EXTENSION.add("exsd");
        EXCLUDED_FILE_EXTENSION.add("svg");
        EXCLUDED_FILE_EXTENSION.add("gmfgen");
        EXCLUDED_FILE_EXTENSION.add("genmodel");
        EXCLUDED_FILE_EXTENSION.add("html");
        EXCLUDED_FILE_EXTENSION.add("mediawiki");
        EXCLUDED_FILE_EXTENSION.add("notation");
        EXCLUDED_FILE_EXTENSION.add("di");
        EXCLUDED_FILE_EXTENSION.add("properties");
        EXCLUDED_FILE_EXTENSION.add("qvto");
        EXCLUDED_FILE_EXTENSION.add("architecture");
        EXCLUDED_FILE_EXTENSION.add("elementtypesconfigurations");
        EXCLUDED_FILE_EXTENSION.add("xwt");
        EXCLUDED_FILE_EXTENSION.add("ctx");
        EXCLUDED_FILE_EXTENSION.add("xmi");
        IGNORED_NS_URI.add("http://www.w3.org/2001/XMLSchema-instance");
        IGNORED_NS_URI.add("http://www.omg.org/XMI");
        IGNORED_NS_URI.add("http://www.omg.org/spec/XMI/20131001");
    }

    @Override
    public IProject[] build(IProject builtProject, PapyrusPluginBuilder papyrusBuilder, int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (builtProject != null) {
            IJavaProject javaProject = JavaCore.create((IProject)builtProject);
            Map<Resource, IFile> resources = this.getEcoreResources(javaProject);
            if (this.isModelValidationActivated()) {
                this.validateModel(resources);
            }
            if (this.isCheckModelDependencyActivated()) {
                this.checkModelDependencies(resources, builtProject);
            }
        }
        return null;
    }

    protected void validateModel(Map<Resource, IFile> resources) {
        for (Map.Entry<Resource, IFile> entry : resources.entrySet()) {
            Collection<Diagnostic> diagnostics = this.validateResource(entry.getKey());
            this.createMarkerErrorFromDiagnostics((IResource)entry.getValue(), diagnostics);
        }
    }

    protected void checkModelDependencies(Map<Resource, IFile> resources, IProject builtProject) throws CoreException {
        Collection<String> currentDeclaredDependencies = this.getAllAvailableDependencies(builtProject);
        for (Map.Entry<Resource, IFile> current : resources.entrySet()) {
            Set<String> requiredDependencies = this.getDependencies(current.getKey(), builtProject);
            requiredDependencies.removeAll(currentDeclaredDependencies);
            requiredDependencies.remove(builtProject.getName());
            if (requiredDependencies.size() <= 0) continue;
            StringBuilder dependenciesToAdd = new StringBuilder();
            Iterator<String> iter = requiredDependencies.iterator();
            while (iter.hasNext()) {
                dependenciesToAdd.append(iter.next());
                if (!iter.hasNext()) continue;
                dependenciesToAdd.append(",");
            }
            IMarker marker = this.createErrorMarker((IResource)current.getValue(), "Missing Dependencies in model");
            marker.setAttribute("Missing Dependencies", (Object)dependenciesToAdd.toString());
        }
    }

    protected Map<Resource, IFile> getEcoreResources(IJavaProject javaProject) {
        HashMap<Resource, IFile> resources = new HashMap<Resource, IFile>();
        try {
            Object[] nonJavaResource;
            Object[] objectArray = nonJavaResource = javaProject.getNonJavaResources();
            int n = nonJavaResource.length;
            int n2 = 0;
            while (n2 < n) {
                Object current = objectArray[n2];
                resources.putAll(this.getEcoreResource(current));
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Activator.log.error((Throwable)e);
        }
        return resources;
    }

    protected Map<Resource, IFile> getEcoreResource(Object container) {
        IFolder folder;
        HashMap<Resource, IFile> resources = new HashMap<Resource, IFile>();
        if (container instanceof IFile) {
            Resource res;
            IFile f = (IFile)container;
            if (this.managedFileExtension(f.getFileExtension()) && !EXCLUDED_FILE_NAME.contains(f.getName()) && (res = this.loadIfPossibleAsEcoreResource(f)) != null) {
                resources.put(res, f);
            }
        } else if (container instanceof IFolder && !EXCLUDED_FOLDER_NAME.contains((folder = (IFolder)container).getName())) {
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource current = iResourceArray[n2];
                    resources.putAll(this.getEcoreResource(current));
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return resources;
    }

    protected Resource loadIfPossibleAsEcoreResource(IFile f) {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setURIConverter(ResourceUtils.createWorkspaceAwareURIConverter());
        URI uri = URI.createPlatformResourceURI((String)f.getFullPath().toOSString(), (boolean)true);
        try {
            Resource res = set.getResource(uri, true);
            return res;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Set<String> getDependencies(Resource resource, IProject builtProject) {
        EcoreUtil.resolveAll((Resource)resource);
        TreeSet<String> dependencies = new TreeSet<String>();
        for (Resource current : resource.getResourceSet().getResources()) {
            if (this.isIgnoredNS_URI(current.getURI().toString()) || !this.managedFileExtension(current.getURI().fileExtension())) continue;
            try {
                dependencies.add(this.getBundleNameFromResource(current));
                dependencies.addAll(this.getModelBundleDependenciesFromXML(resource));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dependencies;
    }

    protected String getBundleNameFromResource(Resource resource) {
        return this.RESOURCE_HELPER.getBundleNameFromResource(resource);
    }

    protected Set<String> getModelBundleDependenciesFromXML(Resource resource) {
        Set<String> importedMetamodels_NS_URI = this.getXMLImportedMetamodelNsURI(resource);
        return this.getBundleNameFromNS_URI(importedMetamodels_NS_URI);
    }

    protected Set<String> getXMLImportedMetamodelNsURI(Resource resource) {
        String libraryFile = null;
        if (!resource.getURI().isPlatform()) {
            throw new UnsupportedOperationException();
        }
        libraryFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true))).getRawLocation().toOSString();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        HashSet<String> uris = new HashSet<String>();
        try {
            DocumentBuilder dBuilder = factory.newDocumentBuilder();
            Document doc = dBuilder.parse(libraryFile);
            Element docElement = doc.getDocumentElement();
            NamedNodeMap attr = docElement.getAttributes();
            int i = 0;
            while (i < attr.getLength()) {
                Node item = attr.item(i);
                if (item.getNodeName().startsWith(XMLNS)) {
                    uris.add(item.getNodeValue());
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            Activator.log.error((Throwable)e);
        }
        catch (SAXException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return uris;
    }

    protected Set<String> getBundleNameFromNS_URI(Collection<String> nsURIs) {
        HashSet<String> result = new HashSet<String>();
        for (String currentNS_URI : nsURIs) {
            if (this.isIgnoredNS_URI(currentNS_URI)) continue;
            String bundleName = this.getBundleNameFromNS_URI(currentNS_URI);
            if (bundleName != null) {
                result.add(bundleName);
                continue;
            }
            Activator.log.warn(NLS.bind((String)Messages.GenericEMFModelBuilder_noBundleFoundForNsUri, (Object)currentNS_URI));
        }
        return result;
    }

    protected String getBundleNameFromNS_URI(String nsURI) {
        if (nsURI.equals("http://www.eclipse.org/uml2/schemas/UML2/2") || nsURI.equals("http://www.eclipse.org/uml2/schemas/Ecore/5")) {
            return "org.eclipse.uml2.uml.resources";
        }
        return this.RESOURCE_HELPER.getBundleNameFromNS_URI(nsURI);
    }

    protected Collection<Diagnostic> validateResource(Resource resource) {
        BasicDiagnostic result = new BasicDiagnostic();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        EValidator.SubstitutionLabelProvider labels = ModelValidationChecker.createSubstitutionLabelProvider((AdapterFactory)adapterFactory);
        HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider> context = new HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider>();
        context.put(EValidator.SubstitutionLabelProvider.class, labels);
        try {
            for (EObject current : resource.getContents()) {
                Diagnostician.INSTANCE.validate(current, (DiagnosticChain)result, context);
            }
        }
        finally {
            adapterFactory.dispose();
        }
        return result.getChildren();
    }

    protected void createMarkerErrorFromDiagnostics(IResource iResource, Collection<Diagnostic> diagnostics) {
        if (diagnostics != null && !diagnostics.isEmpty()) {
            for (Diagnostic diagnostic : diagnostics) {
                this.createMarkerErrorFromDiagnostic(iResource, diagnostic);
            }
        }
    }

    protected void createMarkerErrorFromDiagnostic(IResource iResource, Diagnostic diagnostic) {
        try {
            IMarker marker = MarkersService.createMarker((IResource)iResource, (String)this.getMarkerType(), (Diagnostic)diagnostic);
            System.err.println("Msg: " + diagnostic.getMessage());
            marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)((EObject)diagnostic.getData().get(0))).toString());
            int index = diagnostic.getData().indexOf("Missing Dependencies");
            if (index > 0) {
                String missingDependencies = (String)diagnostic.getData().get(index);
                marker.setAttribute("Missing Dependencies", (Object)missingDependencies);
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        this.createMarkerErrorFromDiagnostics(iResource, diagnostic.getChildren());
    }

    protected String getMarkerType() {
        return "org.eclipse.jdt.core.problem";
    }

    protected final boolean isModelValidationActivated() {
        return Activator.getDefault().getPreferenceStore().getBoolean("PapyrusModelBuilder_ValidateModel");
    }

    protected final boolean isCheckModelDependencyActivated() {
        return Activator.getDefault().getPreferenceStore().getBoolean("PapyrusModelBuilder_CheckModelDependencies");
    }

    protected boolean managedFileExtension(String fileExtension) {
        return !EXCLUDED_FILE_EXTENSION.contains(fileExtension);
    }

    protected boolean isIgnoredNS_URI(String ns_URI) {
        return IGNORED_NS_URI.contains(ns_URI);
    }
}

