/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor.palette;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.codegen.gmfgen.AbstractToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Palette;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Utils_qvto {
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  protected String _activatorFQN(final Palette palette) {
    return palette.getDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
  }
  
  protected String _activatorFQN(final AbstractToolEntry entry) {
    return this.activatorFQN(entry.getGroup().getPalette());
  }
  
  protected String _activatorFQN(final ToolGroup group) {
    return this.activatorFQN(group.getPalette());
  }
  
  @Localization
  public String i18nKey(final EntryBase group) {
    String rv = group.getCreateMethodName();
    String _switchResult = null;
    boolean _matched = false;
    boolean _startsWith = rv.startsWith("get");
    if (_startsWith) {
      _matched=true;
      _switchResult = this._common_qvto.substringAfter(rv, "get");
    }
    if (!_matched) {
      boolean _startsWith_1 = rv.startsWith("create");
      if (_startsWith_1) {
        _matched=true;
        _switchResult = this._common_qvto.substringAfter(rv, "create");
      }
    }
    if (!_matched) {
      _switchResult = rv;
    }
    return _switchResult;
  }
  
  @Localization
  public String i18nTitleKey(final EntryBase group) {
    String _i18nKey = this.i18nKey(group);
    return (_i18nKey + "_title");
  }
  
  @Localization
  public String i18nDescKey(final EntryBase group) {
    String _i18nKey = this.i18nKey(group);
    return (_i18nKey + "_desc");
  }
  
  public Iterable<ToolGroup> collectGroups(final Palette palette) {
    LinkedHashSet<ToolGroup> result = CollectionLiterals.<ToolGroup>newLinkedHashSet();
    boolean _notEquals = (!Objects.equal(palette, null));
    if (_notEquals) {
      result.addAll(palette.getGroups());
      EList<ToolGroup> _groups = palette.getGroups();
      for (final ToolGroup group : _groups) {
        Iterables.<ToolGroup>addAll(result, this.collectSubGroups(group));
      }
    }
    return result;
  }
  
  public Iterable<ToolGroup> collectSubGroups(final ToolGroup group) {
    return this.collectSubGroups(group, CollectionLiterals.<ToolGroup>newLinkedList());
  }
  
  public Iterable<ToolGroup> collectSubGroups(final ToolGroup group, final Collection<ToolGroup> acc) {
    Iterable<ToolGroup> directSubGroups = Iterables.<ToolGroup>filter(group.getEntries(), ToolGroup.class);
    boolean _isEmpty = IterableExtensions.isEmpty(directSubGroups);
    boolean _not = (!_isEmpty);
    if (_not) {
      Iterables.<ToolGroup>addAll(acc, directSubGroups);
      for (final ToolGroup next : directSubGroups) {
        this.collectSubGroups(next, acc);
      }
    }
    return acc;
  }
  
  public Iterable<AbstractToolEntry> collectTools(final Palette palette) {
    final Function1<ToolGroup, Iterable<AbstractToolEntry>> _function = new Function1<ToolGroup, Iterable<AbstractToolEntry>>() {
      @Override
      public Iterable<AbstractToolEntry> apply(final ToolGroup g) {
        return Iterables.<AbstractToolEntry>filter(g.getEntries(), AbstractToolEntry.class);
      }
    };
    return Iterables.<AbstractToolEntry>concat(IterableExtensions.<ToolGroup, Iterable<AbstractToolEntry>>map(this.collectGroups(palette), _function));
  }
  
  public boolean needsNodeToolEntryClass(final Palette palette) {
    final Function1<ToolEntry, Boolean> _function = new Function1<ToolEntry, Boolean>() {
      @Override
      public Boolean apply(final ToolEntry e) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenNode>notEmpty(e.getGenNodes()));
      }
    };
    return IterableExtensions.<ToolEntry>exists(Iterables.<ToolEntry>filter(this.collectTools(palette), ToolEntry.class), _function);
  }
  
  public boolean needsLinkToolEntryClass(final Palette palette) {
    final Function1<ToolEntry, Boolean> _function = new Function1<ToolEntry, Boolean>() {
      @Override
      public Boolean apply(final ToolEntry e) {
        return Boolean.valueOf(Utils_qvto.this._common_qvto.<GenLink>notEmpty(e.getGenLinks()));
      }
    };
    return IterableExtensions.<ToolEntry>exists(Iterables.<ToolEntry>filter(this.collectTools(palette), ToolEntry.class), _function);
  }
  
  public String activatorFQN(final EObject entry) {
    if (entry instanceof AbstractToolEntry) {
      return _activatorFQN((AbstractToolEntry)entry);
    } else if (entry instanceof ToolGroup) {
      return _activatorFQN((ToolGroup)entry);
    } else if (entry instanceof Palette) {
      return _activatorFQN((Palette)entry);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(entry).toString());
    }
  }
}
