/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.genmodel;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.gmf.gmfgraph.Identity;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.MappingTransformer;
import org.eclipse.papyrus.gmf.mappings.AuditContainer;
import org.eclipse.papyrus.gmf.mappings.CanvasMapping;
import org.eclipse.papyrus.gmf.mappings.LinkMapping;
import org.eclipse.papyrus.gmf.mappings.MetricContainer;
import org.eclipse.papyrus.gmf.mappings.TopNodeReference;

public class DiagramRunTimeModelTransformer
extends MappingTransformer {
    private final EPackage myPackage = EcoreFactory.eINSTANCE.createEPackage();

    public DiagramRunTimeModelTransformer(String modelName, String modelNsURI) {
        this.myPackage.setName(modelName);
        this.myPackage.setNsPrefix(String.valueOf(modelName) + "-drt");
        this.myPackage.setNsURI(modelNsURI);
    }

    public EPackage getResult() {
        return this.myPackage;
    }

    @Override
    protected void process(CanvasMapping cme) {
        this.addEClass((Identity)cme.getDiagramCanvas(), NotationPackage.eINSTANCE.getDiagram());
    }

    @Override
    protected void process(TopNodeReference topNode) {
        this.addEClass((Identity)topNode.getChild().getDiagramNode(), NotationPackage.eINSTANCE.getNode());
    }

    @Override
    protected void process(LinkMapping lme) {
        this.addEClass((Identity)lme.getDiagramLink(), NotationPackage.eINSTANCE.getEdge());
    }

    private void addEClass(Identity diaDefElement, EClass superClass) {
        EClass c = this.createEClass(diaDefElement.getName(), superClass);
        this.myPackage.getEClassifiers().add((Object)c);
    }

    private EClass createEClass(String name, EClass superClass) {
        EClass c = EcoreFactory.eINSTANCE.createEClass();
        c.setName(name);
        c.getESuperTypes().add((Object)superClass);
        return c;
    }

    @Override
    protected void process(AuditContainer audits) {
    }

    @Override
    protected void process(MetricContainer metrics) {
    }
}

