/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ResourceSetInfo {
  @Inject
  @Extension
  private Common _common;
  
  /**
   * Inner class of DocumentProvider
   */
  public CharSequence ResourceSetInfo(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("protected class ResourceSetInfo extends ElementInfo {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _modificationStamp = this.getModificationStamp(it);
    _builder.append(_modificationStamp, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setModificationStamp = this.setModificationStamp(it);
    _builder.append(_setModificationStamp, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _editingDomain = this.getEditingDomain(it);
    _builder.append(_editingDomain, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _resourceSet = this.getResourceSet(it);
    _builder.append(_resourceSet, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _loadedResourcesIterator = this.getLoadedResourcesIterator(it);
    _builder.append(_loadedResourcesIterator, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _editorInput = this.getEditorInput(it);
    _builder.append(_editorInput, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _dispose = this.dispose(it);
    _builder.append(_dispose, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isSynchronized = this.isSynchronized(it);
    _builder.append(_isSynchronized, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        CharSequence _setUnSynchronized = this.setUnSynchronized(it);
        _builder.append(_setUnSynchronized, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _setSynchronized = this.setSynchronized(it);
        _builder.append(_setSynchronized, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _stopResourceListening = this.stopResourceListening(it);
        _builder.append(_stopResourceListening, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _startResourceListening = this.startResourceListening(it);
        _builder.append(_startResourceListening, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
      }
    }
    _builder.append("\t");
    CharSequence _isUpdateCache = this.isUpdateCache(it);
    _builder.append(_isUpdateCache, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setUpdateCache = this.setUpdateCache(it);
    _builder.append(_setUpdateCache, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isModifiable = this.isModifiable(it);
    _builder.append(_isModifiable, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setModifiable = this.setModifiable(it);
    _builder.append(_setModifiable, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isReadOnly = this.isReadOnly(it);
    _builder.append(_isReadOnly, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _setReadOnly = this.setReadOnly(it);
    _builder.append(_setReadOnly, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(null, _application_1);
      if (_equals_1) {
        CharSequence _SynchronizerDelegate = this.SynchronizerDelegate(it);
        _builder.append(_SynchronizerDelegate);
        _builder.newLineIfNotEmpty();
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private long myModificationStamp = ");
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("org.eclipse.core.resources.IResource.NULL_STAMP");
      } else {
        _builder.append("0");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      GenApplication _application_1 = it.getEditorGen().getApplication();
      boolean _equals_1 = Objects.equal(null, _application_1);
      if (_equals_1) {
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("private org.eclipse.emf.workspace.util.WorkspaceSynchronizer mySynchronizer;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment_2, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("private java.util.LinkedList<org.eclipse.emf.ecore.resource.Resource> myUnSynchronizedResources = new java.util.LinkedList<org.eclipse.emf.ecore.resource.Resource>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument myDocument;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.ui.IEditorInput myEditorInput;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private boolean myUpdateCache = true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private boolean myModifiable = false;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private boolean myReadOnly = true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private ResourceSetModificationListener myResourceSetListener;");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence constructor(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ResourceSetInfo(org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document, org.eclipse.ui.IEditorInput editorInput) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super(document);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myDocument = document;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myEditorInput = editorInput;");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.append("startResourceListening();");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("myResourceSetListener = new ResourceSetModificationListener(this);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getResourceSet().eAdapters().add(myResourceSetListener);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getModificationStamp(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public long getModificationStamp() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myModificationStamp;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setModificationStamp(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setModificationStamp(long modificationStamp) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myModificationStamp = modificationStamp;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getEditingDomain(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.transaction.TransactionalEditingDomain getEditingDomain() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myDocument.getEditingDomain();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getResourceSet(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.ecore.resource.ResourceSet getResourceSet() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return getEditingDomain().getResourceSet();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * XXX Would be nice to change API and to return List instead of Iterator - there seems to be little sense using latter.
   */
  public CharSequence getLoadedResourcesIterator(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> getLoadedResourcesIterator() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return new java.util.ArrayList<org.eclipse.emf.ecore.resource.Resource>(getResourceSet().getResources()).iterator();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getEditorInput(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.ui.IEditorInput getEditorInput() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myEditorInput;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence dispose(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void dispose() {");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.append("stopResourceListening();");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("getResourceSet().eAdapters().remove(myResourceSetListener);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = getLoadedResourcesIterator(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.resource.Resource resource = it.next();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("resource.unload();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("getEditingDomain().dispose();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isSynchronized(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isSynchronized() {");
    _builder.newLine();
    {
      GenApplication _application = it.getEditorGen().getApplication();
      boolean _equals = Objects.equal(null, _application);
      if (_equals) {
        _builder.append("\t");
        _builder.append("return myUnSynchronizedResources.size() == 0;");
        _builder.newLine();
      } else {
        _builder.append("\t");
        _builder.append("return getModificationStamp() == computeModificationStamp(this);");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setUnSynchronized(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setUnSynchronized(org.eclipse.emf.ecore.resource.Resource resource) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myUnSynchronizedResources.add(resource);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setSynchronized(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setSynchronized(org.eclipse.emf.ecore.resource.Resource resource) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myUnSynchronizedResources.remove(resource);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence stopResourceListening(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public final void stopResourceListening() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mySynchronizer.dispose();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mySynchronizer = null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence startResourceListening(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public final void startResourceListening() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("mySynchronizer = new org.eclipse.emf.workspace.util.WorkspaceSynchronizer(getEditingDomain(), new SynchronizerDelegate());");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isUpdateCache(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isUpdateCache() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myUpdateCache;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setUpdateCache(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setUpdateCache(boolean update) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myUpdateCache = update;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isModifiable(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isModifiable() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myModifiable;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setModifiable(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setModifiable(boolean modifiable) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myModifiable = modifiable;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence isReadOnly(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isReadOnly() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return myReadOnly;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence setReadOnly(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void setReadOnly(boolean readOnly) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("myReadOnly = readOnly;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence SynchronizerDelegate(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.append("\t");
    _builder.newLineIfNotEmpty();
    _builder.append("private class SynchronizerDelegate implements org.eclipse.emf.workspace.util.WorkspaceSynchronizer.Delegate {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _disposeSD = this.disposeSD(it);
    _builder.append(_disposeSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleResourceChangedSD = this.handleResourceChangedSD(it);
    _builder.append(_handleResourceChangedSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleResourceDeletedSD = this.handleResourceDeletedSD(it);
    _builder.append(_handleResourceDeletedSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleResourceMovedSD = this.handleResourceMovedSD(it);
    _builder.append(_handleResourceMovedSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additionsSD = this.additionsSD(it);
    _builder.append(_additionsSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence disposeSD(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public void dispose() {");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleResourceChangedSD(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean handleResourceChanged(final org.eclipse.emf.ecore.resource.Resource resource) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _updateSynchStateSD = this.updateSynchStateSD(it);
    _builder.append(_updateSynchStateSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.widgets.Display.getDefault().asyncExec(new java.lang.Runnable() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("handleElementChanged(ResourceSetInfo.this, resource, null);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleResourceDeletedSD(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean handleResourceDeleted(org.eclipse.emf.ecore.resource.Resource resource) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _updateSynchStateSD = this.updateSynchStateSD(it);
    _builder.append(_updateSynchStateSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.widgets.Display.getDefault().asyncExec(new java.lang.Runnable() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fireElementDeleted(ResourceSetInfo.this.getEditorInput());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleResourceMovedSD(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean handleResourceMoved(org.eclipse.emf.ecore.resource.Resource resource, final org.eclipse.emf.common.util.URI newURI) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _updateSynchStateSD = this.updateSynchStateSD(it);
    _builder.append(_updateSynchStateSD, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (myDocument.getDiagram().eResource() == resource) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.swt.widgets.Display.getDefault().asyncExec(new java.lang.Runnable() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("handleElementMoved(ResourceSetInfo.this.getEditorInput(), newURI);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("handleResourceDeleted(resource);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence updateSynchStateSD(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("synchronized (ResourceSetInfo.this) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (ResourceSetInfo.this.fCanBeSaved) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ResourceSetInfo.this.setUnSynchronized(resource);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additionsSD(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
