/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.ElementTypeRule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceFactory;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class ApplyStereotypeAdviceRule {
    @Extension
    private static ApplyStereotypeAdviceFactory applyStereotypeAdviceConfigurationFactory = ApplyStereotypeAdviceFactory.eINSTANCE;
    @Inject
    @Extension
    private ElementTypeRule _elementTypeRule;
    @Inject
    @Extension
    private Identifiers _identifiers;
    private final HashMap<ArrayList<?>, ApplyStereotypeAdviceConfiguration> _createCache_toAdviceConfiguration = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, StereotypeToApply> _createCache_toStereotypeToApply = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplyStereotypeAdviceConfiguration toAdviceConfiguration(Stereotype umlStereotype, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        ApplyStereotypeAdviceConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlStereotype, umlExtension, supertype});
        HashMap<ArrayList<?>, ApplyStereotypeAdviceConfiguration> hashMap = this._createCache_toAdviceConfiguration;
        synchronized (hashMap) {
            ApplyStereotypeAdviceConfiguration _createApplyStereotypeAdviceConfiguration;
            if (this._createCache_toAdviceConfiguration.containsKey(_cacheKey)) {
                return this._createCache_toAdviceConfiguration.get(_cacheKey);
            }
            _result = _createApplyStereotypeAdviceConfiguration = applyStereotypeAdviceConfigurationFactory.createApplyStereotypeAdviceConfiguration();
            this._createCache_toAdviceConfiguration.put(_cacheKey, _result);
        }
        this._init_toAdviceConfiguration(_result, umlStereotype, umlExtension, supertype);
        return _result;
    }

    private void _init_toAdviceConfiguration(ApplyStereotypeAdviceConfiguration it, Stereotype umlStereotype, ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        String _qualified = this._identifiers.getQualified(StringExtensions.toFirstLower((String)umlStereotype.getName()));
        String _hintSuffix = this._identifiers.hintSuffix(supertype);
        String _plus = String.valueOf(_qualified) + _hintSuffix;
        it.setIdentifier(_plus);
        it.getStereotypesToApply().add((Object)this.toStereotypeToApply(umlStereotype, supertype));
        it.setTarget((ElementTypeConfiguration)this._elementTypeRule.toElementType(umlExtension, supertype));
        String _name = umlStereotype.getName();
        String _plus_1 = "Apply Stereotype " + _name;
        it.setDescription(_plus_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StereotypeToApply toStereotypeToApply(Stereotype umlStereotype, ElementTypeConfiguration supertype) {
        StereotypeToApply _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{umlStereotype, supertype});
        HashMap<ArrayList<?>, StereotypeToApply> hashMap = this._createCache_toStereotypeToApply;
        synchronized (hashMap) {
            StereotypeToApply _createStereotypeToApply;
            if (this._createCache_toStereotypeToApply.containsKey(_cacheKey)) {
                return this._createCache_toStereotypeToApply.get(_cacheKey);
            }
            _result = _createStereotypeToApply = applyStereotypeAdviceConfigurationFactory.createStereotypeToApply();
            this._createCache_toStereotypeToApply.put(_cacheKey, _result);
        }
        this._init_toStereotypeToApply(_result, umlStereotype, supertype);
        return _result;
    }

    private void _init_toStereotypeToApply(StereotypeToApply it, Stereotype umlStereotype, ElementTypeConfiguration supertype) {
        it.getRequiredProfiles().add((Object)umlStereotype.getProfile().getQualifiedName());
        it.setStereotypeQualifiedName(umlStereotype.getQualifiedName());
        it.setUpdateName(true);
    }
}

