/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.gmfgraph.Dimension;
import org.eclipse.papyrus.gmf.gmfgraph.Insets;
import org.eclipse.papyrus.gmf.gmfgraph.Point;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * No mapMode at all, provided only as hook for extenders
 */
@Singleton
@SuppressWarnings("all")
public class MapMode {
  protected CharSequence _mapMode(final Dimension it) {
    StringConcatenation _builder = new StringConcatenation();
    int _dx = it.getDx();
    _builder.append(_dx);
    _builder.append(", ");
    int _dy = it.getDy();
    _builder.append(_dy);
    return _builder;
  }
  
  protected CharSequence _mapMode(final Point it) {
    StringConcatenation _builder = new StringConcatenation();
    int _x = it.getX();
    _builder.append(_x);
    _builder.append(", ");
    int _y = it.getY();
    _builder.append(_y);
    return _builder;
  }
  
  protected CharSequence _mapMode(final Integer it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(it);
    return _builder;
  }
  
  protected CharSequence _mapMode(final Insets it) {
    StringConcatenation _builder = new StringConcatenation();
    int _top = it.getTop();
    _builder.append(_top);
    _builder.append(", ");
    int _left = it.getLeft();
    _builder.append(_left);
    _builder.append(", ");
    int _bottom = it.getBottom();
    _builder.append(_bottom);
    _builder.append(", ");
    int _right = it.getRight();
    _builder.append(_right);
    return _builder;
  }
  
  public CharSequence Activator() {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence mapMode(final Object it) {
    if (it instanceof Integer) {
      return _mapMode((Integer)it);
    } else if (it instanceof Dimension) {
      return _mapMode((Dimension)it);
    } else if (it instanceof Insets) {
      return _mapMode((Insets)it);
    } else if (it instanceof Point) {
      return _mapMode((Point)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
