/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Alexander Shatalin (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.NodeEditPart;
import impl.diagram.editparts.TextAware;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Common_qvto;
import xpt.diagram.editparts.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class ChildNodeLabelEditPart {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private impl.diagram.editparts.ChildNodeLabelEditPart xptChildNodeLabelEditPart;
  
  @Inject
  private NodeEditPart xptNodeEditPart;
  
  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;
  
  @Inject
  private TextAware xptTextAware;
  
  public CharSequence qualifiedClassName(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.xptChildNodeLabelEditPart.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.xptChildNodeLabelEditPart.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.xptChildNodeLabelEditPart.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.xptChildNodeLabelEditPart.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _constructor = this.xptChildNodeLabelEditPart.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _dragTracker = this.getDragTracker(it);
    _builder.append(_dragTracker, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    Object _methods = this.xptTextAware.methods(it, false, it.isLabelReadOnly(), it.isLabelElementIcon(), it.getViewmap(), it.getLabelModelFacet(), it, it.getDiagram());
    _builder.append(_methods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _notationalListeners = this.xptEditpartsCommon.notationalListeners(it);
    _builder.append(_notationalListeners, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleNotificationEvent = this.handleNotificationEvent(it);
    _builder.append(_handleNotificationEvent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    Object _labelFigure = this.xptEditpartsCommon.labelFigure(it.getViewmap());
    _builder.append(_labelFigure, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isSelectable = this.xptChildNodeLabelEditPart.isSelectable(it);
    _builder.append(_isSelectable, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence extendsList(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart");
    return _builder;
  }
  
  public CharSequence implementsList(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("implements org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart");
    return _builder;
  }
  
  public CharSequence attributes(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _fields = this.xptTextAware.fields(it);
    _builder.append(_fields);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence getDragTracker(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.DragTracker getDragTracker(org.eclipse.gef.Request request) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _dragTrackerBody = this.xptChildNodeLabelEditPart.getDragTrackerBody(it);
    _builder.append(_dragTrackerBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createDefaultEditPolicies(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createDefaultEditPoliciesBody = this.xptChildNodeLabelEditPart.createDefaultEditPoliciesBody(it);
    _builder.append(_createDefaultEditPoliciesBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence handleNotificationEvent(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _handleNotificationEventBody = this.xptChildNodeLabelEditPart.handleNotificationEventBody(it);
    _builder.append(_handleNotificationEventBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
