/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.ocl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.parser.OCLProblemHandler;
import org.eclipse.papyrus.gmf.internal.xpand.StreamsHolder;
import org.eclipse.papyrus.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.papyrus.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.papyrus.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.papyrus.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.papyrus.gmf.internal.xpand.model.Scope;
import org.eclipse.papyrus.gmf.internal.xpand.ocl.EmbeddedQVTAnalyzer;
import org.eclipse.papyrus.gmf.internal.xpand.qvtlibraries.XpandGlobalVars;
import org.eclipse.papyrus.gmf.internal.xpand.util.XpandStreamOperations;
import org.eclipse.papyrus.gmf.internal.xpand.xtend.ast.QvtResource;

public class ExpressionHelper {
    private final OCLExpressionCS expressionCS;
    private OCLExpression<EClassifier> oclExpression;
    private EcoreEnvironment oclEnvironment;
    private Diagnostic oclExpressionDiagnostic;
    private SyntaxElement parentElement;

    public ExpressionHelper(OCLExpressionCS exprCS, SyntaxElement parentElement) {
        assert (exprCS != null);
        this.expressionCS = exprCS;
        this.parentElement = parentElement;
    }

    public OCLExpressionCS getCST() {
        return this.expressionCS;
    }

    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EcoreEnvironment env = this.getOCLEnvironment(ctx);
        OCLExpression<EClassifier> expression = this.getOCLExpression(env);
        this.handleOCLAnalyzationErrors(issues);
        return expression != null ? (EClassifier)expression.getType() : null;
    }

    private void handleOCLAnalyzationErrors(Set<AnalysationIssue> issues) {
        if (this.getOclExpressionDiagnostic() != null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, this.getOclExpressionDiagnostic().getMessage(), this));
        }
    }

    public Object evaluate(ExecutionContext ctx) {
        EcoreEnvironment env = this.getOCLEnvironment(ctx);
        OCLExpression<EClassifier> expression = this.getOCLExpression(env);
        if (this.getOclExpressionDiagnostic() != null) {
            throw new EvaluationException(this.getOclExpressionDiagnostic().getMessage(), this);
        }
        QvtOperationalEvaluationVisitor visitor = ctx.createEvaluationVisitor();
        this.defineGlobalVariables(ctx, visitor.getOperationalEvaluationEnv());
        this.initializeStreamsHolder(ctx.getScope(), ctx.getScope().getOutput().getNamedStreams(), visitor.getOperationalEvaluationEnv());
        Object val = visitor.visitExpression(expression);
        this.initializeStreamsHolder(ctx.getScope(), null, visitor.getOperationalEvaluationEnv());
        this.clearGlobalVariables(ctx, visitor.getOperationalEvaluationEnv());
        if (env.getOCLStandardLibrary().getOclInvalid() == val) {
            throw new EvaluationException("Can't evaluate expression: returned value is OclInvalid", this);
        }
        return val;
    }

    private EcoreEnvironment getOCLEnvironment(ExecutionContext ctx) {
        if (this.oclEnvironment == null) {
            this.oclEnvironment = ctx.getOCLEnvironment();
        }
        return this.oclEnvironment;
    }

    private OCLExpression<EClassifier> getOCLExpression(EcoreEnvironment env) {
        if (this.oclExpression == null) {
            this.oclExpression = new EmbeddedQVTAnalyzer(env).analyzeExpression(this.expressionCS);
            this.oclExpressionDiagnostic = this.getOCLDiagnostic(env);
        }
        return this.oclExpression;
    }

    private Diagnostic getOCLDiagnostic(EcoreEnvironment env) {
        if (env.getProblemHandler() instanceof OCLProblemHandler) {
            OCLProblemHandler oclProblemHandler = (OCLProblemHandler)env.getProblemHandler();
            Diagnostic diagnostic = oclProblemHandler.getDiagnostic();
            if (diagnostic != null && diagnostic.getSeverity() == 4) {
                return diagnostic;
            }
            oclProblemHandler.clearDiagnostic();
        }
        return null;
    }

    private Diagnostic getOclExpressionDiagnostic() {
        return this.oclExpressionDiagnostic;
    }

    private void clearGlobalVariables(ExecutionContext ctx, QvtOperationalEvaluationEnv evaluationEnv) {
        Collection<String> globalVarNames = ctx.getScope().getGlobalVarNames();
        if (globalVarNames.isEmpty()) {
            return;
        }
        XpandGlobalVars globalVarsLibInstance = this.getGlobalVarsLibraryInstance(ctx.getScope(), evaluationEnv);
        if (globalVarsLibInstance != null) {
            globalVarsLibInstance.globalVariables = Collections.emptyMap();
        }
    }

    private void defineGlobalVariables(ExecutionContext ctx, QvtOperationalEvaluationEnv evaluationEnv) {
        Scope scope = ctx.getScope();
        Collection<String> globalVarNames = scope.getGlobalVarNames();
        if (globalVarNames.isEmpty()) {
            return;
        }
        XpandGlobalVars globalVarsLibInstance = this.getGlobalVarsLibraryInstance(scope, evaluationEnv);
        if (globalVarsLibInstance != null) {
            HashMap<String, Object> globalVars = new HashMap<String, Object>();
            for (String varName : globalVarNames) {
                globalVars.put(varName, scope.getGlobalVariable(varName).getValue());
            }
            globalVarsLibInstance.globalVariables = globalVars;
        }
    }

    private XpandGlobalVars getGlobalVarsLibraryInstance(Scope scope, QvtOperationalEvaluationEnv evaluationEnv) {
        QvtResource globalVarsOperationResource = scope.findExtension("xpt::GlobalVarOperations");
        if (globalVarsOperationResource != null) {
            for (Module module : globalVarsOperationResource.getModules()) {
                XpandGlobalVars globalVarsLibInstance;
                ModuleInstance moduleInstance = evaluationEnv.getThisOfType(module);
                if (moduleInstance == null || (globalVarsLibInstance = (XpandGlobalVars)moduleInstance.getAdapter(XpandGlobalVars.class)) == null) continue;
                return globalVarsLibInstance;
            }
        }
        return null;
    }

    private void initializeStreamsHolder(Scope scope, StreamsHolder namedStreams, QvtOperationalEvaluationEnv evaluationEnv) {
        QvtResource streamOperationResource = scope.findExtension("xpt::StreamOperations");
        if (streamOperationResource != null) {
            for (Module module : streamOperationResource.getModules()) {
                XpandStreamOperations libInstance;
                ModuleInstance moduleInstance = evaluationEnv.getThisOfType(module);
                if (moduleInstance == null || (libInstance = (XpandStreamOperations)moduleInstance.getAdapter(XpandStreamOperations.class)) == null) continue;
                libInstance.streamsHolder = namedStreams;
            }
        }
    }

    public int getStart() {
        return this.expressionCS.getStartOffset();
    }

    public int getEnd() {
        return this.expressionCS.getEndOffset();
    }

    public String getFileName() {
        return this.parentElement.getFileName();
    }

    public int getLine() {
        return this.parentElement.getLine();
    }

    public OCLExpression<EClassifier> getOCLExpression() {
        return this.oclExpression;
    }
}

