/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.composites;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.wizards.SelectETypeWizardImpl;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectETypeComposite
extends Composite {
    private static final int NUMBER_COLUMN = 3;
    private EClassifier selectedEType = null;
    private EditingDomain editingDomain;
    private Label eTypeLabel;
    private Button selectButton;
    private Text eTypedTextField;
    private ETypeSelectionOptions eTypeSelectionOption;
    private boolean canChangeEPackage = true;
    private final EPackage ePackage;

    public SelectETypeComposite(Composite parent, int style, ETypeSelectionOptions option, boolean canChangeEPackage, EPackage ePackage) {
        super(parent, style);
        this.eTypeSelectionOption = option;
        this.ePackage = ePackage;
        this.canChangeEPackage = canChangeEPackage;
        this.init();
    }

    protected void createCompositeWidget() {
        this.eTypeLabel = new Label((Composite)this, 0);
        this.eTypedTextField = new Text((Composite)this, 2052);
        this.selectButton = new Button((Composite)this, 8);
    }

    private void init() {
        GridLayout gridLayout = new GridLayout(3, false);
        this.setLayout((Layout)gridLayout);
        this.createCompositeWidget();
        this.initializeWidgets();
        this.initializeLabelText();
    }

    private void initializeLabelText() {
        this.eTypeLabel.setText(Messages.Type);
        this.selectButton.setText(Messages.Select);
    }

    protected void initializeWidgets() {
        GridData gd = new GridData(768);
        this.eTypedTextField.setLayoutData((Object)gd);
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectETypeComposite.this.handleBrowse();
            }
        });
    }

    protected void handleBrowse() {
        SelectETypeWizardImpl dialog;
        if (this.eTypeSelectionOption == null) {
            this.eTypeSelectionOption = ETypeSelectionOptions.ECLASSIFIER;
        }
        if ((dialog = new SelectETypeWizardImpl(this.editingDomain, this.eTypeSelectionOption, this.canChangeEPackage, this.ePackage)).open() != 1) {
            this.setEClass(dialog.getSelectedEType());
            this.eTypeSelected();
        }
    }

    protected void eTypeSelected() {
    }

    public void setEClass(EClassifier eClass) {
        this.selectedEType = eClass;
        if (eClass != null) {
            this.eTypedTextField.setText(eClass.getName());
            this.eTypedTextField.redraw();
            this.eTypedTextField.setFocus();
        }
    }

    public void canChangeEType(boolean canChange) {
        this.selectButton.setEnabled(canChange);
    }

    public EClassifier getEType() {
        return this.selectedEType;
    }

    protected void setQueryLabel(Label queryLabel) {
        this.eTypeLabel = queryLabel;
    }

    protected void setBrowseButton(Button browseButton) {
        this.selectButton = browseButton;
    }

    protected void setQueryNameTextField(Text queryNameTextField) {
        this.eTypedTextField = queryNameTextField;
    }

    public void setETypeLabel(Label eTypeLabel) {
        this.eTypeLabel = eTypeLabel;
    }

    public void setSelectButton(Button selectButton) {
        this.selectButton = selectButton;
    }

    public void setETypedTextField(Text eTypedTextField) {
        this.eTypedTextField = eTypedTextField;
    }

    public void setEditingDomain(EditingDomain editingDomain2) {
        this.editingDomain = editingDomain2;
    }

    public void setEType(EClass type) {
        this.selectedEType = type;
        if (this.eTypedTextField != null) {
            this.eTypedTextField.setText(this.selectedEType.getName());
            this.eTypedTextField.redraw();
        }
    }

    public static enum ETypeSelectionOptions {
        ECLASSIFIER,
        EDATATYPE,
        ECLASS;

    }
}

