/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.nattable.utils.IPapyrusNattableStatus;

public class PapyrusNattableStatus
extends Status
implements IPapyrusNattableStatus {
    private int severity;

    public PapyrusNattableStatus(int severity, String pluginId, int code, String message, Throwable exception) {
        super(severity, pluginId, code, message, exception);
    }

    public PapyrusNattableStatus(int severity, String pluginId, String message, Throwable exception) {
        super(severity, pluginId, message, exception);
    }

    public PapyrusNattableStatus(int severity, String pluginId, String message) {
        super(severity, pluginId, message);
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public boolean matches(int severityMask) {
        return (this.severity & severityMask) != 0;
    }

    protected void setSeverity(int severity) {
        Assert.isLegal((severity == 0 || severity == 4 || severity == 2 || severity == 1 || severity == 8 || severity == 22 || severity == 50 || severity == 100 ? 1 : 0) != 0);
        this.severity = severity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status ");
        if (this.severity == 0) {
            buf.append("OK");
        } else if (this.severity == 4) {
            buf.append("ERROR");
        } else if (this.severity == 2) {
            buf.append("WARNING");
        } else if (this.severity == 1) {
            buf.append("INFO");
        } else if (this.severity == 8) {
            buf.append("CANCEL");
        } else if (this.severity == 22) {
            buf.append("PASTE_CONFIGURATiON_INFO");
        } else if (this.severity == 50) {
            buf.append("PASTE_CONFIGURATiON_WARNING");
        } else if (this.severity == 100) {
            buf.append("PASTE_CONFIGURATiON_ERROR");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(": ");
        buf.append(this.getPlugin());
        buf.append(" code=");
        buf.append(this.getCode());
        buf.append(' ');
        buf.append(this.getMessage());
        buf.append(' ');
        buf.append(this.getException());
        return buf.toString();
    }
}

