/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard.widget;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TernaryButton
extends Composite
implements SelectionListener {
    private State state;
    private Button button = new Button((Composite)this, 8);
    private boolean defaultValue;
    private IObservableValue observable;

    public TernaryButton(Composite parent, boolean defaultValue) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.button.addSelectionListener((SelectionListener)this);
        this.defaultValue = defaultValue;
        this.setState(State.DEFAULT);
    }

    public void widgetSelected(SelectionEvent e) {
        switch (this.state) {
            case DEFAULT: {
                this.setState(State.TRUE);
                break;
            }
            case TRUE: {
                this.setState(State.FALSE);
                break;
            }
            case FALSE: {
                this.setState(State.DEFAULT);
            }
        }
        this.observable.setValue((Object)this.getState());
    }

    public void setObservable(IObservableValue value) {
        this.observable = value;
    }

    public void setState(State state) {
        this.state = state;
        this.button.setImage(state.getImage(this.defaultValue));
        this.button.setText(state.getText(this.defaultValue));
    }

    public State getState() {
        return this.state;
    }

    public boolean getValue() {
        return this.state.getValue(this.defaultValue);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public static enum State {
        DEFAULT,
        TRUE,
        FALSE;


        public boolean getValue(boolean defaultValue) {
            switch (this) {
                case DEFAULT: {
                    return defaultValue;
                }
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
            }
            throw new RuntimeException();
        }

        public Image getImage(boolean defaultValue) {
            switch (this) {
                case DEFAULT: {
                    if (defaultValue) {
                        return Activator.getDefault().getImage("/icons/default_true.gif");
                    }
                    return Activator.getDefault().getImage("/icons/default_false.gif");
                }
                case TRUE: {
                    return Activator.getDefault().getImage("/icons/true.gif");
                }
                case FALSE: {
                    return Activator.getDefault().getImage("/icons/false.gif");
                }
            }
            throw new RuntimeException();
        }

        public String getText(boolean defaultValue) {
            switch (this) {
                case DEFAULT: {
                    if (defaultValue) {
                        return Messages.TernaryButton_defaultTrue;
                    }
                    return Messages.TernaryButton_defaultFalse;
                }
                case TRUE: {
                    return Messages.TernaryButton_true;
                }
                case FALSE: {
                    return Messages.TernaryButton_false;
                }
            }
            throw new RuntimeException();
        }
    }
}

