/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.merged;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureFramework;

public class MergedArchitectureDomain
extends MergedADElement {
    public MergedArchitectureDomain() {
        super(null);
    }

    public Collection<Stakeholder> getStakeholders() {
        LinkedHashSet stakeholders = new LinkedHashSet();
        for (ADElement element : this.elements) {
            ArchitectureDomain domain = (ArchitectureDomain)element;
            stakeholders.addAll(domain.getStakeholders());
        }
        return Collections.unmodifiableCollection(stakeholders);
    }

    public Collection<Concern> getConcerns() {
        LinkedHashSet concerns = new LinkedHashSet();
        for (ADElement element : this.elements) {
            ArchitectureDomain domain = (ArchitectureDomain)element;
            concerns.addAll(domain.getConcerns());
        }
        return Collections.unmodifiableCollection(concerns);
    }

    public Collection<MergedArchitectureContext> getContexts() {
        HashMap<String, MergedArchitectureContext> contexts = new HashMap<String, MergedArchitectureContext>();
        for (ADElement element : this.elements) {
            ArchitectureDomain domain = (ArchitectureDomain)element;
            for (ArchitectureContext context : domain.getContexts()) {
                MergedArchitectureContext merged = (MergedArchitectureContext)contexts.get(context.getName());
                if (merged == null) {
                    if (context instanceof ArchitectureDescriptionLanguage) {
                        merged = new MergedArchitectureDescriptionLanguage(this);
                        contexts.put(context.getName(), merged);
                    } else {
                        merged = new MergedArchitectureFramework(this);
                        contexts.put(context.getName(), merged);
                    }
                }
                merged.merge((ADElement)context);
            }
        }
        return Collections.unmodifiableCollection(contexts.values());
    }

    public void merge(ArchitectureDomain domain) {
        this.elements.add(domain);
    }
}

