/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services.internal;

import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IServiceFactory;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceState;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.internal.ServiceTypeEntry;

public class ServiceFactoryEntry
extends ServiceTypeEntry {
    private Object serviceInstance;
    private IServiceFactory factoryInstance;

    public ServiceFactoryEntry(ServiceDescriptor serviceDescriptor) {
        super(serviceDescriptor);
        this.setState(ServiceState.registered);
    }

    public ServiceFactoryEntry(ServiceDescriptor descriptor, IServiceFactory factoryInstance) {
        super(descriptor);
        this.factoryInstance = factoryInstance;
        this.setState(ServiceState.registered);
    }

    @Override
    public Object getServiceInstance() throws ServiceException {
        if (this.factoryInstance == null) {
            throw new BadStateException("Service is not available (state=" + this.state.toString() + "). ", this.state, this.serviceDescriptor);
        }
        if (this.serviceInstance == null) {
            this.serviceInstance = this.factoryInstance.createServiceInstance();
            if (this.serviceInstance == null) {
                throw new ServiceException("Service Factory '" + this.getDescriptor().getKey() + " return a null service. It should return a valid service.");
            }
        }
        return this.serviceInstance;
    }

    public String toString() {
        return "ServiceEntry [serviceDescriptor=" + this.serviceDescriptor.toString() + ", serviceInstance=" + this.serviceInstance + "]";
    }

    @Override
    public void createService() throws ServiceException {
        this.checkState(ServiceState.registered);
        if (this.factoryInstance != null) {
            this.setState(ServiceState.created);
            return;
        }
        try {
            this.factoryInstance = (IServiceFactory)this.instanciateService();
        }
        catch (Exception e) {
            this.setState(ServiceState.error);
            throw new ServiceException(e);
        }
        this.setState(ServiceState.created);
    }

    @Override
    public void initService(ServicesRegistry servicesRegistry) throws ServiceException {
        this.checkState(ServiceState.created);
        try {
            this.factoryInstance.init(servicesRegistry);
        }
        catch (ServiceException e) {
            this.setState(ServiceState.error);
            throw e;
        }
        catch (Exception e) {
            this.setState(ServiceState.error);
            throw new ServiceException(e);
        }
        this.setState(ServiceState.initialized);
    }

    @Override
    public void startService() throws ServiceException {
        this.checkState(ServiceState.initialized);
        this.setState(ServiceState.starting);
        try {
            this.factoryInstance.startService();
        }
        catch (ServiceException e) {
            this.setState(ServiceState.error);
            throw e;
        }
        catch (Exception e) {
            this.setState(ServiceState.error);
            throw new ServiceException(e);
        }
        this.setState(ServiceState.started);
    }

    @Override
    public void disposeService() throws ServiceException {
        if (this.factoryInstance == null) {
            return;
        }
        this.factoryInstance.disposeService();
        this.factoryInstance = null;
        this.serviceInstance = null;
        this.setState(ServiceState.disposed);
    }
}

