/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ViewUtils {
    public static String getContainingDiagramType(View view) {
        if (view instanceof Diagram) {
            Diagram diagram = (Diagram)view;
            return diagram.getType();
        }
        EObject eContainer = view.eContainer();
        if (eContainer instanceof View) {
            View parentView = (View)eContainer;
            return ViewUtils.getContainingDiagramType(parentView);
        }
        return null;
    }

    public static boolean isContained(View child, View parent) {
        View view = child;
        while (view != null) {
            if (view == parent) {
                return true;
            }
            EObject eContainer = view.eContainer();
            if (!(eContainer instanceof View)) break;
            view = (View)eContainer;
        }
        return false;
    }

    public static boolean isViewFor(View view, EClass ... eClasses) {
        EObject element = view.getElement();
        EClass[] eClassArray = eClasses;
        int n = eClasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (eClass.isInstance((Object)element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsViewFor(View parentView, EObject eObject) {
        if (parentView.getElement() == eObject) {
            return true;
        }
        EList children = parentView.getChildren();
        for (View child : children) {
            if (!ViewUtils.containsViewFor(child, eObject)) continue;
            return true;
        }
        return false;
    }

    public static void selectInViewer(View view, EditPartViewer viewer) {
        EditPart editPart = (EditPart)viewer.getEditPartRegistry().get(view);
        if (editPart != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)editPart));
        }
    }
}

