/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationPropertiesCatalogManager;
import org.eclipse.papyrus.emf.facet.custom.core.internal.exception.CustomizationCatalogRuntimeException;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationPropertiesCatalog;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationcatalogFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.util.emf.catalog.CatalogSet;
import org.eclipse.papyrus.emf.facet.util.emf.core.ICatalogManager;

public class CustomizationPropertiesCatalogManager
implements ICatalogManager,
ICustomizationPropertiesCatalogManager {
    private static final String CUSTOM_SUFIX = "customproperties";
    private final CustomizationPropertiesCatalog catalog = CustomizationcatalogFactory.eINSTANCE.createCustomizationPropertiesCatalog();

    public boolean canBeManaged(EObject root) {
        return root instanceof FacetSet;
    }

    public void manage(EObject root) {
        if (root instanceof FacetSet) {
            FacetSet customProperties = (FacetSet)root;
            if (customProperties.getName().endsWith(CUSTOM_SUFIX)) {
                this.catalog.getInstalledEntries().add((Object)customProperties);
            }
        } else {
            throw new CustomizationCatalogRuntimeException("Only facetSets must be stored in the customization properties catalog");
        }
    }

    public void setCatalogSet(CatalogSet catalogSet) {
        catalogSet.getCatalogs().add((Object)this.catalog);
    }

    @Override
    public List<FacetSet> getAllRegisteredCustomizationPropertySet() {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        for (EObject eObject : this.catalog.getInstalledEntries()) {
            if (eObject instanceof FacetSet) {
                FacetSet facetSet = (FacetSet)eObject;
                result.add(facetSet);
                continue;
            }
            throw new RuntimeException("Only facetSets must be stored in the customization properties catalog");
        }
        return result;
    }

    @Override
    public List<FacetOperation> getCustomizationPropertiesByName(String customPropName) {
        ArrayList<FacetOperation> result = new ArrayList<FacetOperation>();
        for (EObject facetSet : this.catalog.getInstalledEntries()) {
            TreeIterator iterator = facetSet.eAllContents();
            while (iterator.hasNext()) {
                FacetOperation customProperty;
                EObject eObject = (EObject)iterator.next();
                if (!(eObject instanceof FacetOperation) || !customPropName.equals((customProperty = (FacetOperation)eObject).getName())) continue;
                result.add(customProperty);
            }
        }
        return result;
    }
}

