/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.project.management.internal.operations;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.papyrus.dev.project.management.internal.operations.DependencyKind;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class VersionRules {
    private final VersionRule rule = VersionRule.composeAll(new CurrentVersionRule(), new FixedRangeRule(dep -> dep.startsWith("org.apache.batik"), "[1.6.0,1.7.0)"), new SkipRule("com.ibm.icu"), new FixedRangeRule("com.google.guava", "21.0.0"));

    public VersionRange getDependencyVersionRange(DependencyKind kind, String dependency) {
        return (VersionRange)this.rule.apply(kind, dependency);
    }

    static Version getCurrentMinorVersion(String dependencyName, boolean isPackageImport) {
        Version result = Version.emptyVersion;
        if (!isPackageImport) {
            IPluginModelBase model = PluginRegistry.findModel((String)dependencyName);
            if (model != null) {
                result = Version.valueOf((String)model.getPluginBase().getVersion());
            }
        } else {
            result = Stream.of(PluginRegistry.getActiveModels((boolean)false)).filter(p -> VersionRules.exports(p, dependencyName)).map(p -> VersionRules.getExportedVersion(p, dependencyName)).findFirst().orElse(Version.emptyVersion);
        }
        if (!result.equals((Object)Version.emptyVersion)) {
            result = new Version(result.getMajor(), result.getMinor(), 0);
        }
        return result;
    }

    private static boolean exports(IPluginModelBase pluginModel, String packageName) {
        boolean result = false;
        BundleDescription desc = pluginModel.getBundleDescription();
        if (desc != null) {
            result = Stream.of(desc.getExportPackages()).anyMatch(ep -> packageName.equals(ep.getName()));
        }
        return result;
    }

    private static Version getExportedVersion(IPluginModelBase pluginModel, String packageName) {
        Version result = Version.emptyVersion;
        BundleDescription desc = pluginModel.getBundleDescription();
        if (desc != null) {
            result = Stream.of(desc.getExportPackages()).filter(ep -> packageName.equals(ep.getName())).map(BaseDescription::getVersion).filter(Objects::nonNull).findAny().orElse(Version.emptyVersion);
        }
        return result;
    }

    private static abstract class AbstractRule
    implements VersionRule {
        private final BiPredicate<DependencyKind, String> predicate;

        AbstractRule(BiPredicate<DependencyKind, String> predicate) {
            this.predicate = predicate;
        }

        AbstractRule(Predicate<String> predicate) {
            this((DependencyKind kind, String dep) -> predicate.test((String)dep));
        }

        @Override
        public boolean test(DependencyKind kind, String dependencyName) {
            return this.predicate.test(kind, dependencyName);
        }
    }

    private static class CurrentVersionRule
    extends AbstractRule {
        private CurrentVersionRule() {
            super((DependencyKind kind, String dep) -> true);
        }

        @Override
        public VersionRange apply(DependencyKind kind, String dependencyName) {
            Version current = VersionRules.getCurrentMinorVersion(dependencyName, kind == DependencyKind.IMPORT_PACKAGE);
            Version next = current == null || current.equals((Object)Version.emptyVersion) ? null : new Version(current.getMajor() + 1, 0, 0);
            return next == null ? null : new VersionRange('[', current, next, ')');
        }
    }

    private static final class FixedRangeRule
    extends AbstractRule {
        private final VersionRange range;

        FixedRangeRule(String bundleID, String range) {
            this(bundleID::equals, VersionRange.valueOf((String)range));
        }

        FixedRangeRule(Predicate<String> predicate, String range) {
            this(predicate, VersionRange.valueOf((String)range));
        }

        FixedRangeRule(Predicate<String> predicate, VersionRange range) {
            super(predicate);
            this.range = range;
        }

        @Override
        public VersionRange apply(DependencyKind kind, String dependencyName) {
            return this.range;
        }
    }

    private static final class SkipRule
    extends AbstractRule {
        SkipRule(String dependencyName) {
            this(dependencyName::equals);
        }

        SkipRule(Predicate<String> predicate) {
            super(predicate);
        }

        @Override
        public VersionRange apply(DependencyKind kind, String dependencyName) {
            return null;
        }
    }

    private static interface VersionRule
    extends BiPredicate<DependencyKind, String>,
    BiFunction<DependencyKind, String, VersionRange> {
        default public VersionRule compose(final VersionRule other) {
            return new VersionRule(){

                @Override
                public VersionRange apply(DependencyKind kind, String dependencyName) {
                    return this.test(kind, dependencyName) ? (VersionRange)this.apply(kind, dependencyName) : (VersionRange)other.apply(kind, dependencyName);
                }

                @Override
                public boolean test(DependencyKind kind, String dependencyName) {
                    return this.test(kind, dependencyName) || other.test(kind, dependencyName);
                }
            };
        }

        public static VersionRule composeAll(VersionRule default_, VersionRule ... rules) {
            VersionRule result = default_;
            VersionRule[] versionRuleArray = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                VersionRule next = versionRuleArray[n2];
                result = next.compose(result);
                ++n2;
            }
            return result;
        }
    }
}

