/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.listener;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IOpenable;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.modelexplorer.Activator;

public class DoubleClickListener
implements IDoubleClickListener {
    private final Supplier<ServicesRegistry> servicesRegistry;

    @Deprecated
    public DoubleClickListener(ServicesRegistry servicesRegistry) {
        this((Supplier<ServicesRegistry>)Suppliers.ofInstance((Object)servicesRegistry));
    }

    public DoubleClickListener(Supplier<ServicesRegistry> servicesRegistrySupplier) {
        this.servicesRegistry = servicesRegistrySupplier;
    }

    public void doubleClick(DoubleClickEvent event) {
        IPageManager pageManager;
        ISelection selection = event.getSelection();
        try {
            pageManager = (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)((ServicesRegistry)this.servicesRegistry.get()));
        }
        catch (Exception e) {
            Activator.log.error("Impossibility to load the page manager", (Throwable)e);
            return;
        }
        if (pageManager != null && selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            LinkedList<EObject> pagesToOpen = new LinkedList<EObject>();
            EObject pageToSelect = null;
            while (iter.hasNext()) {
                Object currentObject = iter.next();
                EObject diag = EMFHelper.getEObject(currentObject);
                if (!this.isPage(diag, pageManager)) continue;
                if (pageManager.isOpen((Object)diag)) {
                    pageToSelect = diag;
                    continue;
                }
                pagesToOpen.add(diag);
            }
            if (!pagesToOpen.isEmpty()) {
                for (EObject page : pagesToOpen) {
                    pageManager.openPage((Object)page);
                }
            } else if (pageToSelect != null) {
                pageManager.selectPage(pageToSelect);
            }
        }
    }

    protected boolean isPage(EObject element, IPageManager pageManager) {
        if (pageManager.allPages().contains(element)) {
            return true;
        }
        Object openable = Platform.getAdapterManager().getAdapter((Object)element, IOpenable.class);
        return openable instanceof IOpenable;
    }
}

