/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.layout;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;

public class OverlayLocator
implements Locator {
    private IFigure reference;
    private IDecoratorTarget.Direction position = null;

    public OverlayLocator(IFigure reference, IDecoratorTarget.Direction position) {
        assert (reference != null);
        this.reference = reference;
        this.position = position;
    }

    public void relocate(IFigure target) {
        PrecisionRectangle bounds = this.reference instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)this.reference).getHandleBounds()) : new PrecisionRectangle(this.reference.getBounds());
        this.reference.translateToAbsolute((Translatable)bounds);
        target.translateToRelative((Translatable)bounds);
        int width = target.getBounds().width;
        int halfWidth = width / 2;
        int height = target.getBounds().height;
        int halfHeight = height / 2;
        if (IDecoratorTarget.Direction.NORTH_WEST.equals(this.position)) {
            target.setLocation(bounds.getTopLeft().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.NORTH.equals(this.position)) {
            target.setLocation(bounds.getTop().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.NORTH_EAST.equals(this.position)) {
            target.setLocation(bounds.getTopRight().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.SOUTH_WEST.equals(this.position)) {
            target.setLocation(bounds.getBottomLeft().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.SOUTH.equals(this.position)) {
            target.setLocation(bounds.getBottom().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.SOUTH_EAST.equals(this.position)) {
            target.setLocation(bounds.getBottomRight().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.WEST.equals(this.position)) {
            target.setLocation(bounds.getLeft().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.EAST.equals(this.position)) {
            target.setLocation(bounds.getRight().getTranslated(-halfWidth, -halfHeight));
        } else if (IDecoratorTarget.Direction.CENTER.equals(this.position)) {
            target.setLocation(bounds.getCenter().getTranslated(-halfWidth, -halfHeight));
        }
    }
}

