/**
 * Copyright (c) 2007, 2010, 2013 Borland Software Corporation and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Alexander Shatalin (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #372479, #386838
 */
package aspects.xpt.editor;

import aspects.xpt.Common;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import metamodel.MetaModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.CodeStyle;
import xpt.Common_qvto;
import xpt.diagram.editpolicies.LinkUtils_qvto;
import xpt.diagram.updater.Utils_qvto;

@Singleton
@SuppressWarnings("all")
public class VisualIDRegistry extends xpt.editor.VisualIDRegistry {
  @Inject
  @Extension
  private MetaModel _metaModel;
  
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private LinkUtils_qvto _linkUtils_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private CodeStyle xptCodeStyle;
  
  @Override
  public CharSequence getDiagramVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _diagramVisualIDMethodName = this.getDiagramVisualIDMethodName(it);
    _builder.append(_diagramVisualIDMethodName);
    _builder.append("(org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (domainElement == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _visualID = xpt.editor.VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * Support for extra contstraints to check about model element.
   * Includes expression fields for interpreted constrains (like ocl or regexp).
   * For each model element that has an associated constraint, there's a method is<DomainElement>_<UID>()
   * that performs extra specification as defined by value expression
   * 
   * FIXME don't use static fields, replace with instance/separate cache (e.g. accessible from Activator)
   */
  @Override
  public CharSequence constraintMethods(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenExpressionProviderContainer _expressionProviders = it.getEditorGen().getExpressionProviders();
      boolean _notEquals = (!Objects.equal(null, _expressionProviders));
      if (_notEquals) {
        {
          final Function1<GenTopLevelNode, Boolean> _function = new Function1<GenTopLevelNode, Boolean>() {
            @Override
            public Boolean apply(final GenTopLevelNode n) {
              boolean _isSansDomain = n.isSansDomain();
              return Boolean.valueOf((!_isSansDomain));
            }
          };
          final Function1<GenTopLevelNode, Boolean> _function_1 = new Function1<GenTopLevelNode, Boolean>() {
            @Override
            public Boolean apply(final GenTopLevelNode n) {
              GenConstraint _modelElementSelector = n.getModelFacet().getModelElementSelector();
              return Boolean.valueOf((!Objects.equal(_modelElementSelector, null)));
            }
          };
          Iterable<GenTopLevelNode> _filter = IterableExtensions.<GenTopLevelNode>filter(IterableExtensions.<GenTopLevelNode>filter(it.getTopLevelNodes(), _function), _function_1);
          for(final GenTopLevelNode topNode : _filter) {
            CharSequence _constraintMethod = this.constraintMethod(topNode);
            _builder.append(_constraintMethod);
          }
        }
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenChildNode, Boolean> _function_2 = new Function1<GenChildNode, Boolean>() {
            @Override
            public Boolean apply(final GenChildNode n) {
              boolean _isSansDomain = n.isSansDomain();
              return Boolean.valueOf((!_isSansDomain));
            }
          };
          final Function1<GenChildNode, Boolean> _function_3 = new Function1<GenChildNode, Boolean>() {
            @Override
            public Boolean apply(final GenChildNode n) {
              GenConstraint _modelElementSelector = n.getModelFacet().getModelElementSelector();
              return Boolean.valueOf((!Objects.equal(_modelElementSelector, null)));
            }
          };
          Iterable<GenChildNode> _filter_1 = IterableExtensions.<GenChildNode>filter(IterableExtensions.<GenChildNode>filter(it.getChildNodes(), _function_2), _function_3);
          for(final GenChildNode childNode : _filter_1) {
            CharSequence _constraintMethod_1 = this.constraintMethod(childNode);
            _builder.append(_constraintMethod_1);
          }
        }
        _builder.newLineIfNotEmpty();
        {
          final Function1<GenLink, Boolean> _function_4 = new Function1<GenLink, Boolean>() {
            @Override
            public Boolean apply(final GenLink n) {
              boolean _isSansDomain = n.isSansDomain();
              return Boolean.valueOf((!_isSansDomain));
            }
          };
          Iterable<GenLink> _filter_2 = IterableExtensions.<GenLink>filter(it.getLinks(), _function_4);
          for(final GenLink link : _filter_2) {
            CharSequence _constraintMethod_2 = this.constraintMethod(link.getModelFacet(), link);
            _builder.append(_constraintMethod_2);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence checkDomainElementConstraints(final TypeModelFacet it, final GenCommonBase commonBase) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenConstraint _modelElementSelector = it.getModelElementSelector();
      boolean _notEquals = (!Objects.equal(null, _modelElementSelector));
      if (_notEquals) {
        {
          if (((commonBase instanceof GenLink) || (!(it.getModelElementSelector().getProvider() instanceof GenJavaExpressionProvider)))) {
            _builder.append("&& ");
            CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(commonBase);
            _builder.append(_domainElementConstraintMethodName);
            _builder.append("(");
            CharSequence _CastEObject = this._metaModel.CastEObject(it.getMetaClass(), "domainElement");
            _builder.append(_CastEObject);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("&& ");
            CharSequence _domainElementConstraintMethodName_1 = this.domainElementConstraintMethodName(commonBase);
            _builder.append(_domainElementConstraintMethodName_1);
            _builder.append("(containerView, ");
            CharSequence _CastEObject_1 = this._metaModel.CastEObject(it.getMetaClass(), "domainElement");
            _builder.append(_CastEObject_1);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  @Override
  protected CharSequence _domainElementConstraintMethod(final GenJavaExpressionProvider it, final GenCommonBase diagramElement, final ValueExpression expression, final GenClass context) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    {
      if ((diagramElement instanceof GenLink)) {
        _builder.append("private static boolean ");
        CharSequence _domainElementConstraintMethodName = this.domainElementConstraintMethodName(diagramElement);
        _builder.append(_domainElementConstraintMethodName);
        _builder.append("(");
        CharSequence _QualifiedClassName = this._metaModel.QualifiedClassName(context);
        _builder.append(_QualifiedClassName);
        _builder.append(" domainElement) {");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("private static boolean ");
        CharSequence _domainElementConstraintMethodName_1 = this.domainElementConstraintMethodName(diagramElement);
        _builder.append(_domainElementConstraintMethodName_1);
        _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, ");
        CharSequence _QualifiedClassName_1 = this._metaModel.QualifiedClassName(context);
        _builder.append(_QualifiedClassName_1);
        _builder.append(" domainElement) {");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((it.isInjectExpressionBody() && ((!Objects.equal(expression.getBody(), null)) && (expression.getBody().length() != 0)))) {
        String _body = expression.getBody();
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
      } else {
        if ((it.isThrowException() || (it.isInjectExpressionBody() && (Objects.equal(expression.getBody(), null) || (expression.getBody().length() == 0))))) {
          _builder.append("// FIXME: implement this method ");
          _builder.newLine();
          _builder.append("// Ensure that you remove @generated or mark it @generated NOT");
          _builder.newLine();
          _builder.append("throw new java.lang.UnsupportedOperationException(\"No java implementation provided in \'");
          CharSequence _domainElementConstraintMethodName_2 = this.domainElementConstraintMethodName(diagramElement);
          _builder.append(_domainElementConstraintMethodName_2);
          _builder.append("\' operation\");");
          CharSequence _nonNLS = this._common.nonNLS();
          _builder.append(_nonNLS);
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("return false;");
          _builder.newLine();
        }
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence runtimeTypedInstance(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure ");
    CharSequence _runtimeTypedInstanceName = this.runtimeTypedInstanceName(it);
    _builder.append(_runtimeTypedInstanceName);
    _builder.append(" = new org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String ");
    CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
    _builder.append(_visualIdMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_1 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String ");
    CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
    _builder.append(_modelIDMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
    _builder.append(_modelIDMethodCall, "\t\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_2 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String ");
    CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
    _builder.append(_nodeVisualIDMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _nodeVisualIDMethodCall = this.getNodeVisualIDMethodCall(it);
    _builder.append(_nodeVisualIDMethodCall, "\t\t");
    _builder.append("(containerView, domainElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_3 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean ");
    CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
    _builder.append(_checkNodeVisualIDMethodName, "\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, String candidate) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _checkNodeVisualIDMethodCall = this.checkNodeVisualIDMethodCall(it);
    _builder.append(_checkNodeVisualIDMethodCall, "\t\t");
    _builder.append("(containerView, domainElement, candidate);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_4 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean ");
    CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
    _builder.append(_isCompartmentVisualIDMethodName, "\t");
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _isCompartmentVisualIDMethodCall = this.isCompartmentVisualIDMethodCall(it);
    _builder.append(_isCompartmentVisualIDMethodCall, "\t\t");
    _builder.append("(visualID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_5 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean ");
    CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
    _builder.append(_isSemanticLeafVisualIDMethodName, "\t");
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _isSemanticLeafVisualIDMethodCall = this.isSemanticLeafVisualIDMethodCall(it);
    _builder.append(_isSemanticLeafVisualIDMethodCall, "\t\t");
    _builder.append("(visualID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getModelID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _modelIDMethodName = this.getModelIDMethodName(it);
    _builder.append(_modelIDMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View diagram = view.getDiagram();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("while (view != diagram) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.emf.ecore.EAnnotation annotation = view.getEAnnotation(\"Shortcut\"); ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if (annotation != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return annotation.getDetails().get(\"modelID\"); ");
    CharSequence _nonNLS_1 = this._common.nonNLS(1);
    _builder.append(_nonNLS_1, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("view = (org.eclipse.gmf.runtime.notation.View) view.eContainer();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return diagram != null ? diagram.getType() : null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _typeMethodName = this.getTypeMethodName(it);
    _builder.append(_typeMethodName);
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return visualID;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getViewVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
    _builder.append(_visualIdMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (view instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (");
    CharSequence _modelID = xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t\t");
    _builder.append(".equals(view.getType())) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return ");
    CharSequence _visualID = xpt.editor.VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t\t\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t");
    _builder.append("(view.getType());");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence unrecognizedVID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("return \"\";");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _visualIdMethodName = this.getVisualIdMethodName(it);
    _builder.append(_visualIdMethodName);
    _builder.append("(String type) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return type;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getNodeVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
    _builder.append(_nodeVisualIDMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (domainElement == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String containerModelID = ");
    CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
    _builder.append(_modelIDMethodCall, "\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (!");
    CharSequence _modelID = xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t");
    _builder.append(".equals(containerModelID)");
    {
      EList<String> _shortcutsProvidedFor = it.getShortcutsProvidedFor();
      for(final String spf : _shortcutsProvidedFor) {
        CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
        _builder.append(_checkContainerModelID, "\t");
      }
    }
    _builder.append(") { ");
    CharSequence _nonNLS_All = this._common.nonNLS_All(it.getShortcutsProvidedFor());
    _builder.append(_nonNLS_All, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_1, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String containerVisualID;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _modelID_1 = xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID_1, "\t");
    _builder.append(".equals(containerModelID)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualID = xpt.editor.VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t\t\t");
    _builder.append(";\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _unrecognizedVID_2 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_2, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (containerVisualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (containerVisualID) {");
    _builder.newLine();
    {
      EList<GenContainerBase> _allContainers = it.getAllContainers();
      for(final GenContainerBase container : _allContainers) {
        _builder.append("\t\t\t");
        CharSequence _caseDomainContainerVisualID = this.caseDomainContainerVisualID(container);
        _builder.append(_caseDomainContainerVisualID, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _unrecognizedVID_3 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getLinkWithClassVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static String ");
    CharSequence _linkWithClassVisualIDMethodName = this.getLinkWithClassVisualIDMethodName(it);
    _builder.append(_linkWithClassVisualIDMethodName);
    _builder.append("(org.eclipse.emf.ecore.EObject domainElement) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (domainElement == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    CharSequence _unrecognizedVID = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    {
      final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
        @Override
        public Boolean apply(final GenLink l) {
          return Boolean.valueOf(VisualIDRegistry.this._linkUtils_qvto.isTypeLink(l));
        }
      };
      Iterable<GenLink> _filter = IterableExtensions.<GenLink>filter(it.getLinks(), _function);
      for(final GenLink typeLink : _filter) {
        CharSequence _returnVisualID = this.returnVisualID(typeLink);
        _builder.append(_returnVisualID, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _unrecognizedVID_1 = this.unrecognizedVID(it);
    _builder.append(_unrecognizedVID_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence canCreateNode(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _canCreateNodeMethodName = this.canCreateNodeMethodName(it);
    _builder.append(_canCreateNodeMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, String nodeVisualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("String containerModelID = ");
    CharSequence _modelIDMethodCall = this.getModelIDMethodCall(it);
    _builder.append(_modelIDMethodCall, "\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (!");
    CharSequence _modelID = xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID, "\t");
    _builder.append(".equals(containerModelID)");
    {
      EList<String> _shortcutsProvidedFor = it.getShortcutsProvidedFor();
      for(final String spf : _shortcutsProvidedFor) {
        CharSequence _checkContainerModelID = this.checkContainerModelID(spf);
        _builder.append(_checkContainerModelID, "\t");
      }
    }
    _builder.append(") { ");
    CharSequence _nonNLS_All = this._common.nonNLS_All(it.getShortcutsProvidedFor());
    _builder.append(_nonNLS_All, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String containerVisualID;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (");
    CharSequence _modelID_1 = xpt.editor.VisualIDRegistry.modelID(it);
    _builder.append(_modelID_1, "\t");
    _builder.append(".equals(containerModelID)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualIDMethodCall = this.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(containerView);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (containerView instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("containerVisualID = ");
    CharSequence _visualID = xpt.editor.VisualIDRegistry.visualID(it);
    _builder.append(_visualID, "\t\t\t");
    _builder.append(";\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (containerVisualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (containerVisualID) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    {
      final Function1<GenContainerBase, Boolean> _function = new Function1<GenContainerBase, Boolean>() {
        @Override
        public Boolean apply(final GenContainerBase e) {
          return Boolean.valueOf(VisualIDRegistry.this._common_qvto.<GenCommonBase>notEmpty(VisualIDRegistry.this.getEssentialVisualChildren(e)));
        }
      };
      Iterable<GenContainerBase> _filter = IterableExtensions.<GenContainerBase>filter(it.getAllContainers(), _function);
      for(final GenContainerBase container : _filter) {
        CharSequence _checkEssentialChildren = this.checkEssentialChildren(container);
        _builder.append(_checkEssentialChildren, "\t\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    {
      final Function1<GenLink, Boolean> _function_1 = new Function1<GenLink, Boolean>() {
        @Override
        public Boolean apply(final GenLink l) {
          return Boolean.valueOf(VisualIDRegistry.this._common_qvto.<GenCommonBase>notEmpty(VisualIDRegistry.this.getEssentialVisualChildren(l)));
        }
      };
      Iterable<GenLink> _filter_1 = IterableExtensions.<GenLink>filter(it.getLinks(), _function_1);
      for(final GenLink link : _filter_1) {
        CharSequence _checkEssentialChildren_1 = this.checkEssentialChildren(link);
        _builder.append(_checkEssentialChildren_1, "\t\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence checkEssentialChild(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (");
    CharSequence _visualID = xpt.editor.VisualIDRegistry.visualID(it);
    _builder.append(_visualID);
    _builder.append(".equals(nodeVisualID)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence isCompartmentVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _isCompartmentVisualIDMethodName = this.isCompartmentVisualIDMethodName(it);
    _builder.append(_isCompartmentVisualIDMethodName);
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    {
      boolean _notEmpty = this._common_qvto.<GenCompartment>notEmpty(it.getCompartments());
      if (_notEmpty) {
        _builder.append("\t");
        _builder.append("if (visualID != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("switch (visualID) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        {
          EList<GenCompartment> _compartments = it.getCompartments();
          for(final GenCompartment compartment : _compartments) {
            CharSequence _caseVisualID = this.caseVisualID(compartment);
            _builder.append(_caseVisualID, "\t\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public String isSemanticLeafVisualID(final GenDiagram it) {
    final Function1<GenNode, Boolean> _function = new Function1<GenNode, Boolean>() {
      @Override
      public Boolean apply(final GenNode n) {
        return Boolean.valueOf((IterableExtensions.isEmpty(VisualIDRegistry.this._utils_qvto.getSemanticChildren(n)) && IterableExtensions.<GenCompartment>forall(n.getCompartments(), new Function1<GenCompartment, Boolean>() {
          @Override
          public Boolean apply(final GenCompartment c) {
            return Boolean.valueOf(IterableExtensions.isEmpty(VisualIDRegistry.this._utils_qvto.getSemanticChildren(c)));
          }
        })));
      }
    };
    final Function1<GenNode, Integer> _function_1 = new Function1<GenNode, Integer>() {
      @Override
      public Integer apply(final GenNode n) {
        return Integer.valueOf(n.getVisualID());
      }
    };
    List<GenNode> leafs = IterableExtensions.<GenNode, Integer>sortBy(IterableExtensions.<GenNode>filter(it.getAllNodes(), _function), _function_1);
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _isSemanticLeafVisualIDMethodName = this.isSemanticLeafVisualIDMethodName(it);
    _builder.append(_isSemanticLeafVisualIDMethodName);
    _builder.append("(String visualID) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (visualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (visualID) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    CharSequence _caseVisualID = this.caseVisualID(it);
    _builder.append(_caseVisualID, "\t\t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    {
      boolean _notEmpty = this._common_qvto.<GenNode>notEmpty(leafs);
      if (_notEmpty) {
        _builder.append("\t\t\t");
        {
          for(final GenNode leaf : leafs) {
            CharSequence _caseVisualID_1 = this.caseVisualID(leaf);
            _builder.append(_caseVisualID_1, "\t\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  @Override
  public CharSequence checkNodeVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean ");
    CharSequence _checkNodeVisualIDMethodName = this.checkNodeVisualIDMethodName(it);
    _builder.append(_checkNodeVisualIDMethodName);
    _builder.append("(org.eclipse.gmf.runtime.notation.View containerView, org.eclipse.emf.ecore.EObject domainElement, String candidate) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("if (candidate == null){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//unrecognized id is always bad");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("String basic = ");
    CharSequence _nodeVisualIDMethodName = this.getNodeVisualIDMethodName(it);
    _builder.append(_nodeVisualIDMethodName, "\t");
    _builder.append("(containerView, domainElement);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return candidate.equals(basic);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence domainElementConstraintMethodName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("is");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    return _builder;
  }
  
  public CharSequence domainElementConstraintMethod(final GenExpressionProviderBase it, final GenCommonBase diagramElement, final ValueExpression expression, final GenClass context) {
    if (it instanceof GenExpressionInterpreter) {
      return _domainElementConstraintMethod((GenExpressionInterpreter)it, diagramElement, expression, context);
    } else if (it instanceof GenJavaExpressionProvider) {
      return _domainElementConstraintMethod((GenJavaExpressionProvider)it, diagramElement, expression, context);
    } else if (it != null) {
      return _domainElementConstraintMethod(it, diagramElement, expression, context);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, diagramElement, expression, context).toString());
    }
  }
}
