/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.assistants.generator;

import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ElementTypeFilter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.PopupAssistant;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.uml.profile.assistants.generator.FiltersUtil;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class PopupAssistantRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private FiltersUtil _filtersUtil;
    @Inject
    @Extension
    private UML _uML;
    private final HashMap<ArrayList<?>, PopupAssistant> _createCache_toPopupAssistant = CollectionLiterals.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopupAssistant toPopupAssistant(ImpliedExtension umlExtension, ElementTypeConfiguration basetype) {
        PopupAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{umlExtension, basetype});
        HashMap<ArrayList<?>, PopupAssistant> hashMap = this._createCache_toPopupAssistant;
        synchronized (hashMap) {
            PopupAssistant _createPopupAssistant;
            if (this._createCache_toPopupAssistant.containsKey(_cacheKey)) {
                return this._createCache_toPopupAssistant.get(_cacheKey);
            }
            _result = _createPopupAssistant = assistantFactory.createPopupAssistant();
            this._createCache_toPopupAssistant.put(_cacheKey, _result);
        }
        this._init_toPopupAssistant(_result, umlExtension, basetype);
        return _result;
    }

    private void _init_toPopupAssistant(PopupAssistant it, ImpliedExtension umlExtension, ElementTypeConfiguration basetype) {
        it.setElementTypeID(this._identifiers.toElementTypeID(umlExtension, basetype));
        it.setOwnedFilter(this._filtersUtil.andProfileApplied(this._filtersUtil.reduce(this.createPossibleOwnersFilter(basetype, umlExtension)), this._uML.getProfile((Object)umlExtension)));
    }

    private Filter createPossibleOwnersFilter(final ElementTypeConfiguration basetype, final ImpliedExtension umlExtension) {
        Functions.Function2<Filter, ElementTypeConfiguration, Filter> _function = new Functions.Function2<Filter, ElementTypeConfiguration, Filter>(){

            public Filter apply(Filter filter, ElementTypeConfiguration elementType) {
                Filter _xifexpression = null;
                boolean _canContainType = PopupAssistantRule.this._uMLElementTypes.canContainType(elementType, basetype);
                if (_canContainType) {
                    ElementTypeFilter _filter = PopupAssistantRule.this._filtersUtil.toFilter(elementType, PopupAssistantRule.this._uML.getProfile((Object)umlExtension));
                    _xifexpression = PopupAssistantRule.this._filtersUtil.operator_or(filter, (Filter)_filter);
                } else {
                    _xifexpression = filter;
                }
                return _xifexpression;
            }
        };
        return (Filter)IterableExtensions.fold((Iterable)this._uMLElementTypes.getBaseElementTypes(), null, (Functions.Function2)_function);
    }
}

