/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.nattable.common.editor.AbstractEMFNattableEditor;
import org.eclipse.papyrus.infra.nattable.common.modelresource.PapyrusNattableModel;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.internal.preferences.EditorPreferences;
import org.eclipse.papyrus.infra.ui.internal.preferences.YesNo;
import org.eclipse.papyrus.junit.matchers.CommandMatchers;
import org.eclipse.papyrus.junit.utils.EditorUtils;
import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.eclipse.papyrus.junit.utils.rules.AbstractModelFixture;
import org.eclipse.papyrus.junit.utils.rules.ActiveDiagram;
import org.eclipse.papyrus.junit.utils.rules.ActiveTable;
import org.eclipse.papyrus.junit.utils.rules.ShowView;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.runner.Description;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PapyrusEditorFixture
extends AbstractModelFixture<TransactionalEditingDomain> {
    private final Collection<IEditorPart> editorsToClose = Lists.newArrayList();
    private final List<String> excludedTypeView = Arrays.asList("Note");
    private final boolean ensureOperationHistoryIntegrity;
    private YesNo initialEditorLayoutStorageMigrationPreference;
    private IMultiDiagramEditor editor;
    private DiagramEditorWithFlyOutPalette activeDiagramEditor;
    private AbstractEMFNattableEditor activeTableEditor;
    private ModelExplorerView modelExplorer;
    private Class<?> testClass;
    private Description testDescription;
    private Collection<IViewPart> viewsToClose;
    private ListMultimap<Description, IFile> modelFiles;
    private IOperationHistoryListener operationHistoryIntegrityListener;
    private IOperationHistory operationHistory;

    public PapyrusEditorFixture() {
        this(true);
    }

    public PapyrusEditorFixture(boolean ensureOperationHistoryIntegrity) {
        this.ensureOperationHistoryIntegrity = ensureOperationHistoryIntegrity;
    }

    public IMultiDiagramEditor getEditor() {
        return this.editor;
    }

    public IMultiDiagramEditor getEditor(String path) {
        IMultiDiagramEditor result = null;
        String fileName = new Path(path).lastSegment();
        IEditorReference[] iEditorReferenceArray = this.getWorkbenchPage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference next = iEditorReferenceArray[n2];
            if ("org.eclipse.papyrus.infra.core.papyrusEditor".equals(next.getId()) && fileName.equals(next.getName())) {
                result = (IMultiDiagramEditor)next.getEditor(true);
            }
            ++n2;
        }
        return result;
    }

    @Override
    protected void starting(Description description) {
        this.testClass = description.getTestClass();
        this.testDescription = description;
        this.initialEditorLayoutStorageMigrationPreference = EditorPreferences.getInstance().getConvertSharedPageLayoutToPrivate();
        EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(YesNo.NO);
        if (this.hasRequiredViews()) {
            this.openRequiredViews();
        }
        this.modelFiles = ArrayListMultimap.create();
        this.openAll(description);
        ActiveDiagram activeDiagram = JUnitUtils.getAnnotation(description, ActiveDiagram.class);
        if (activeDiagram != null) {
            String name = activeDiagram.value();
            this.activateDiagram(name);
            if (this.activeDiagramEditor == null || !name.equals(this.getActiveDiagramEditor().getDiagram().getName())) {
                this.openDiagram(name);
            }
        } else {
            ActiveTable activeTable = JUnitUtils.getAnnotation(description, ActiveTable.class);
            if (activeTable != null) {
                String name = activeTable.value();
                this.activateTable(name);
                if (this.activeTableEditor == null || !name.equals(this.getActiveTableEditor().getTable().getName())) {
                    this.openTable(name);
                }
            }
        }
        super.starting(description);
        if (this.ensureOperationHistoryIntegrity) {
            IWorkspaceCommandStack stack = (IWorkspaceCommandStack)this.getEditingDomain().getCommandStack();
            final IUndoContext emfContext = stack.getDefaultUndoContext();
            this.operationHistory = stack.getOperationHistory();
            this.operationHistoryIntegrityListener = new IOperationHistoryListener(){

                public void historyNotification(OperationHistoryEvent event) {
                    IUndoableOperation undo;
                    IUndoContext diagramContext;
                    if (event.getEventType() == 4 && PapyrusEditorFixture.this.activeDiagramEditor != null && (diagramContext = PapyrusEditorFixture.this.activeDiagramEditor.getDiagramEditDomain().getDiagramCommandStack().getUndoContext()) != null && (undo = event.getOperation()) != null && !undo.hasContext(emfContext)) {
                        undo.addContext(emfContext);
                    }
                }
            };
            this.operationHistory.addOperationHistoryListener(this.operationHistoryIntegrityListener);
        }
    }

    @Override
    protected void finished(Description description) {
        try {
            this.modelFiles = null;
            Throwable exception = null;
            for (IEditorPart editor : ImmutableList.copyOf(this.editorsToClose)) {
                try {
                    this.close(editor);
                }
                catch (Exception e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                exception.printStackTrace();
                Assert.fail((String)("Failed to close an editor: " + exception.getLocalizedMessage()));
            }
        }
        finally {
            try {
                if (this.operationHistoryIntegrityListener != null) {
                    this.operationHistory.removeOperationHistoryListener(this.operationHistoryIntegrityListener);
                    this.operationHistoryIntegrityListener = null;
                    this.operationHistory = null;
                }
            }
            finally {
                this.editorsToClose.clear();
                this.editor = null;
                this.activeDiagramEditor = null;
                EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(this.initialEditorLayoutStorageMigrationPreference);
                try {
                    if (this.hasRequiredViews()) {
                        this.closeRequiredViews();
                    }
                }
                finally {
                    super.finished(description);
                }
            }
        }
    }

    @Override
    public TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain result = null;
        if (this.editor != null) {
            result = this.getEditingDomain(this.editor);
        }
        return result;
    }

    public TransactionalEditingDomain getEditingDomain(IMultiDiagramEditor editor) {
        TransactionalEditingDomain result = null;
        try {
            result = (TransactionalEditingDomain)this.getServiceRegistry(editor).getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to get editing domain from Papyrus editor: " + e.getLocalizedMessage()));
        }
        return result;
    }

    @Override
    protected TransactionalEditingDomain createEditingDomain() {
        return null;
    }

    protected IMultiDiagramEditor open(final IFile modelFile) {
        boolean firstEditor = this.editorsToClose.isEmpty();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PapyrusEditorFixture.this.editor = EditorUtils.openPapyrusEditor(modelFile);
                    PapyrusEditorFixture.this.editorsToClose.add(PapyrusEditorFixture.this.editor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Failed to open Papyrus editor: " + e.getLocalizedMessage()));
                }
            }
        });
        if (firstEditor && !this.editorsToClose.isEmpty()) {
            final IWorkbenchPage page = this.editor.getSite().getPage();
            page.addPartListener(new IPartListener(){

                public void partClosed(IWorkbenchPart part) {
                    PapyrusEditorFixture.this.editorsToClose.remove(part);
                    if (part == PapyrusEditorFixture.this.editor) {
                        PapyrusEditorFixture.this.editor = null;
                    }
                    if (PapyrusEditorFixture.this.editorsToClose.isEmpty()) {
                        page.removePartListener((IPartListener)this);
                    }
                }

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                }
            });
        }
        this.flushDisplayEvents();
        return this.editor;
    }

    protected IMultiDiagramEditor openOne(Description description) {
        IFile papyrusModel = this.getProject().getFile(((Resource)Iterables.getOnlyElement(this.initModelResources(description))).getURI().trimFileExtension().appendFileExtension("di"));
        this.modelFiles.put((Object)description, (Object)papyrusModel);
        return this.open(papyrusModel);
    }

    protected Iterable<IMultiDiagramEditor> openAll(Description description) {
        ArrayList result = Lists.newArrayList();
        for (Resource resource : this.initModelResources(description)) {
            if (!resource.getURI().fileExtension().equals("uml")) continue;
            IFile papyrusModel = this.getProject().getFile(resource.getURI().trimFileExtension().appendFileExtension("di"));
            this.modelFiles.put((Object)description, (Object)papyrusModel);
            result.add(this.open(papyrusModel));
        }
        return result;
    }

    protected IMultiDiagramEditor reopenOne(Description description) {
        IFile papyrusModel = (IFile)this.modelFiles.get((Object)description).get(0);
        return this.open(papyrusModel);
    }

    public IMultiDiagramEditor open() {
        return this.openOne(this.testDescription);
    }

    public IMultiDiagramEditor open(String resourcePath) {
        return this.open(new Path(resourcePath).removeFileExtension().lastSegment(), AbstractModelFixture.ResourceKind.BUNDLE, resourcePath);
    }

    public IMultiDiagramEditor open(String targetPath, String resourcePath) {
        return this.open(targetPath, AbstractModelFixture.ResourceKind.BUNDLE, resourcePath);
    }

    public IMultiDiagramEditor open(String targetPath, AbstractModelFixture.ResourceKind resourceKind, String resourcePath) {
        IFile papyrusModel = this.getProject().getFile(this.initModelResource(targetPath, resourceKind, resourcePath).getURI().trimFileExtension().appendFileExtension("di"));
        return this.open(papyrusModel);
    }

    public IMultiDiagramEditor reopen() {
        return this.reopenOne(this.testDescription);
    }

    public void activate() {
        if (this.editor != null) {
            this.activate((IWorkbenchPart)this.editor);
        }
    }

    public void activate(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        if (page.getActivePart() != part) {
            page.activate(part);
            this.flushDisplayEvents();
        }
    }

    public void close() {
        if (this.editor != null) {
            this.close((IEditorPart)this.editor);
            this.editor = null;
        }
    }

    public void close(IEditorPart editor) {
        editor.getSite().getPage().closeEditor(editor, false);
        this.flushDisplayEvents();
    }

    public ModelExplorerView getModelExplorerView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ModelExplorerPageBookView view;
                try {
                    view = (ModelExplorerPageBookView)PapyrusEditorFixture.this.getWorkbenchPage().showView("org.eclipse.papyrus.views.modelexplorer.modelexplorer");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    return;
                }
                IPage currentPage = view.getCurrentPage();
                ModelExplorerPage page = (ModelExplorerPage)currentPage;
                IViewPart viewer = page.getViewer();
                PapyrusEditorFixture.this.modelExplorer = (ModelExplorerView)viewer;
            }
        });
        return this.modelExplorer;
    }

    protected final IWorkbenchPage getWorkbenchPage() {
        IWorkbench bench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null) {
            window = bench.getWorkbenchWindows()[0];
        }
        return window.getActivePage();
    }

    public ServicesRegistry getServiceRegistry() {
        return this.getServiceRegistry(this.editor);
    }

    public ServicesRegistry getServiceRegistry(IMultiDiagramEditor editor) {
        return editor.getServicesRegistry();
    }

    public ModelSet getModelSet() {
        return this.getModelSet(this.editor);
    }

    public ModelSet getModelSet(IMultiDiagramEditor editor) {
        try {
            return (ModelSet)this.getServiceRegistry(editor).getService(ModelSet.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to get model set from Papyrus editor: " + e.getLocalizedMessage()));
            return null;
        }
    }

    @Override
    public Package getModel() {
        return this.getModel(this.editor);
    }

    public Package getModel(IMultiDiagramEditor editor) {
        Package result = null;
        ModelSet modelSet = this.getModelSet(editor);
        UmlModel uml = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        MatcherAssert.assertThat((String)"No UML model present in resource set", (Object)uml.getResource(), (Matcher)CoreMatchers.notNullValue());
        result = (Package)EcoreUtil.getObjectByType((Collection)uml.getResource().getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        MatcherAssert.assertThat((String)"Model resource contains no UML Package", (Object)result, (Matcher)CoreMatchers.notNullValue());
        return result;
    }

    public IPageManager getPageManager() {
        return this.getPageManager(this.editor);
    }

    public IPageManager getPageManager(IMultiDiagramEditor editor) {
        try {
            return (IPageManager)this.getServiceRegistry(editor).getService(IPageManager.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to get page manager from Papyrus editor: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public PapyrusEditorFixture activateDiagram(String name) {
        return this.activateDiagram(this.editor, name);
    }

    public PapyrusEditorFixture activateTable(String name) {
        return this.activateTable(this.editor, name);
    }

    public PapyrusEditorFixture activateDiagram(IMultiDiagramEditor editor, final String name) {
        this.activate((IWorkbenchPart)editor);
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] select = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IEditorPage page) {
                if (name.equals(page.getPageTitle()) && page.getIEditorPart() instanceof DiagramEditorWithFlyOutPalette) {
                    select[0] = page;
                    PapyrusEditorFixture.this.setActiveDiagramEditor((DiagramEditorWithFlyOutPalette)page.getIEditorPart());
                }
            }

            public void accept(IComponentPage page) {
            }
        });
        if (select[0] != null) {
            sashContainer.selectPage(select[0]);
            this.flushDisplayEvents();
        }
        return this;
    }

    public PapyrusEditorFixture activateTable(IMultiDiagramEditor editor, final String name) {
        this.activate((IWorkbenchPart)editor);
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] select = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IEditorPage page) {
                if (name.equals(page.getPageTitle()) && page.getIEditorPart() instanceof AbstractEMFNattableEditor) {
                    select[0] = page;
                    PapyrusEditorFixture.this.setActiveTableEditor((AbstractEMFNattableEditor)page.getIEditorPart());
                }
            }

            public void accept(IComponentPage page) {
            }
        });
        if (select[0] != null) {
            sashContainer.selectPage(select[0]);
            this.flushDisplayEvents();
        }
        return this;
    }

    private void setActiveDiagramEditor(DiagramEditorWithFlyOutPalette editor) {
        this.activeDiagramEditor = editor;
        this.activeTableEditor = null;
    }

    private void setActiveTableEditor(AbstractEMFNattableEditor editor) {
        this.activeTableEditor = editor;
        this.activeDiagramEditor = null;
    }

    public PapyrusEditorFixture activateDiagram(DiagramEditPart diagram) {
        return this.activateDiagram(this.editor, diagram);
    }

    public PapyrusEditorFixture activateDiagram(IMultiDiagramEditor editor, final DiagramEditPart diagram) {
        this.activate((IWorkbenchPart)editor);
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] select = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IEditorPage page) {
                DiagramEditorWithFlyOutPalette nested = (DiagramEditorWithFlyOutPalette)TypeUtils.as((Object)page.getIEditorPart(), DiagramEditorWithFlyOutPalette.class);
                if (nested != null && nested.getDiagramEditPart() == diagram) {
                    select[0] = page;
                    PapyrusEditorFixture.this.setActiveDiagramEditor(nested);
                }
            }

            public void accept(IComponentPage page) {
            }
        });
        if (select[0] != null) {
            sashContainer.selectPage(select[0]);
            this.flushDisplayEvents();
        }
        return this;
    }

    public PapyrusEditorFixture openDiagram(String name) {
        return this.openDiagram(this.editor, name);
    }

    public PapyrusEditorFixture openTable(String name) {
        return this.openTable(this.editor, name);
    }

    public PapyrusEditorFixture openDiagram(IMultiDiagramEditor editor, String name) {
        this.activate((IWorkbenchPart)editor);
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)editor.getServicesRegistry());
            NotationModel notation = (NotationModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
            Diagram diagram = notation.getDiagram(name);
            ((IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)editor.getServicesRegistry())).openPage((Object)diagram);
            this.flushDisplayEvents();
            this.activateDiagram(editor, name);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize test", e);
        }
        return this;
    }

    public PapyrusEditorFixture openTable(IMultiDiagramEditor editor, String name) {
        this.activate((IWorkbenchPart)editor);
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)editor.getServicesRegistry());
            PapyrusNattableModel notation = (PapyrusNattableModel)modelSet.getModel("org.eclipse.papyrus.infra.nattable.resource.NattableModel");
            Table table = notation.getTable(name);
            ((IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)editor.getServicesRegistry())).openPage((Object)table);
            this.flushDisplayEvents();
            this.activateTable(editor, name);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize test", e);
        }
        return this;
    }

    public String closeDiagram() {
        String result = this.getActiveDiagramEditor().getDiagram().getName();
        this.closeDiagram(this.editor, result);
        return result;
    }

    public PapyrusEditorFixture closeDiagram(String name) {
        return this.closeDiagram(this.editor, name);
    }

    public PapyrusEditorFixture closeDiagram(IMultiDiagramEditor editor, String name) {
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)editor.getServicesRegistry());
            NotationModel notation = (NotationModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
            Diagram diagram = notation.getDiagram(name);
            if (diagram != null) {
                ((IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)editor.getServicesRegistry())).closePage((Object)diagram);
                this.flushDisplayEvents();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot close diagram", e);
        }
        return this;
    }

    public DiagramEditorWithFlyOutPalette getActiveDiagramEditor() {
        IEditorPart activeEditor;
        DiagramEditorWithFlyOutPalette result = this.activeDiagramEditor;
        if (result == null && (activeEditor = this.getWorkbenchPage().getActiveEditor()) instanceof IMultiDiagramEditor && (activeEditor = ((IMultiDiagramEditor)activeEditor).getActiveEditor()) instanceof DiagramEditorWithFlyOutPalette) {
            result = (DiagramEditorWithFlyOutPalette)activeEditor;
            this.setActiveDiagramEditor(result);
        }
        MatcherAssert.assertThat((String)"No diagram active", (Object)result, (Matcher)CoreMatchers.notNullValue());
        return result;
    }

    public AbstractEMFNattableEditor getActiveTableEditor() {
        IEditorPart activeEditor;
        AbstractEMFNattableEditor result = this.activeTableEditor;
        if (result == null && (activeEditor = this.getWorkbenchPage().getActiveEditor()) instanceof IMultiDiagramEditor && (activeEditor = ((IMultiDiagramEditor)activeEditor).getActiveEditor()) instanceof AbstractEMFNattableEditor) {
            result = (AbstractEMFNattableEditor)activeEditor;
            this.setActiveTableEditor(result);
        }
        MatcherAssert.assertThat((String)"No table active", (Object)result, (Matcher)CoreMatchers.notNullValue());
        return result;
    }

    public DiagramEditPart getActiveDiagram() {
        return this.getActiveDiagramEditor().getDiagramEditPart();
    }

    public INattableModelManager getActiveTableManager() {
        return (INattableModelManager)this.getActiveTableEditor().getAdapter(INattableModelManager.class);
    }

    public DiagramEditPart getDiagram(String name) {
        return this.getDiagram(this.editor, name);
    }

    public DiagramEditPart getDiagram(IMultiDiagramEditor editor, final String name) {
        IDiagramWorkbenchPart diagramPart;
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] matchedPage = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IEditorPage page) {
                if (name.equals(page.getPageTitle()) && page.getIEditorPart() instanceof DiagramEditorWithFlyOutPalette) {
                    matchedPage[0] = page;
                }
            }

            public void accept(IComponentPage page) {
            }
        });
        IEditorPage editorPage = (IEditorPage)TypeUtils.as((Object)matchedPage[0], IEditorPage.class);
        IDiagramWorkbenchPart iDiagramWorkbenchPart = diagramPart = editorPage == null ? null : (IDiagramWorkbenchPart)TypeUtils.as((Object)editorPage.getIEditorPart(), IDiagramWorkbenchPart.class);
        if (diagramPart != null) {
            if (diagramPart.getDiagramEditPart() == null) {
                diagramPart.setFocus();
            }
            return diagramPart.getDiagramEditPart();
        }
        return null;
    }

    public EditPart findEditPart(EObject modelElement) {
        return this.findEditPart((IDiagramWorkbenchPart)this.getActiveDiagramEditor(), modelElement);
    }

    public EditPart findEditPart(IMultiDiagramEditor editor, EObject modelElement) {
        IEditorPart activeEditor = editor.getActiveEditor();
        MatcherAssert.assertThat((String)"No diagram active", (Object)activeEditor, (Matcher)CoreMatchers.instanceOf(DiagramEditor.class));
        return this.findEditPart((IDiagramWorkbenchPart)((DiagramEditor)activeEditor), modelElement);
    }

    public EditPart findEditPart(IDiagramWorkbenchPart editor, EObject modelElement) {
        DiagramEditPart diagram = editor.getDiagramEditPart();
        return this.findEditPart((EditPart)diagram, modelElement);
    }

    public EditPart getShapeCompartment(EditPart shapeEditPart) {
        return PapyrusEditorFixture.stream(shapeEditPart.getChildren(), EditPart.class).filter(ShapeCompartmentEditPart.class::isInstance).findFirst().orElseGet(PapyrusEditorFixture.failOnAbsence("No shape compartment"));
    }

    private static <T> Stream<T> stream(Collection rawCollection, Class<T> type) {
        return rawCollection.stream().filter(type::isInstance).map(type::cast);
    }

    private static <T> Supplier<T> failOnAbsence(String message) {
        return () -> {
            Assert.fail((String)message);
            return null;
        };
    }

    public EditPart findOrphanEditPart(String type) {
        IDiagramWorkbenchPart activeEditor = (IDiagramWorkbenchPart)this.editor.getActiveEditor();
        EditPart result = null;
        UnmodifiableIterator views = Iterators.filter((Iterator)activeEditor.getDiagram().eAllContents(), View.class);
        while (views.hasNext()) {
            View next = (View)views.next();
            EObject element = next.getElement();
            if (element != null || !type.equals(next.getType())) continue;
            result = (EditPart)activeEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(next);
            break;
        }
        return result;
    }

    public EditPart findOrphanEditPart() {
        IDiagramWorkbenchPart activeEditor = (IDiagramWorkbenchPart)this.editor.getActiveEditor();
        EditPart result = null;
        UnmodifiableIterator views = Iterators.filter((Iterator)activeEditor.getDiagram().eAllContents(), View.class);
        while (views.hasNext()) {
            View next = (View)views.next();
            String type = next.getType();
            EObject element = next.getElement();
            if (element != null || this.excludedTypeView.contains(type)) continue;
            result = (EditPart)activeEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(next);
            break;
        }
        return result;
    }

    public EditPart findEditPart(EditPart scope, EObject modelElement) {
        Iterator iter;
        EditPart result = null;
        View view = (View)PlatformHelper.getAdapter((Object)scope, View.class);
        if (view != null && view.getElement() == modelElement) {
            result = scope;
        }
        if (result == null) {
            iter = scope.getChildren().iterator();
            while (result == null && iter.hasNext()) {
                result = this.findEditPart((EditPart)iter.next(), modelElement);
            }
        }
        if (result == null && scope instanceof GraphicalEditPart) {
            iter = ((GraphicalEditPart)scope).getSourceConnections().iterator();
            while (result == null && iter.hasNext()) {
                result = this.findEditPart((EditPart)iter.next(), modelElement);
            }
            if (result == null) {
                iter = ((GraphicalEditPart)scope).getTargetConnections().iterator();
                while (result == null && iter.hasNext()) {
                    result = this.findEditPart((EditPart)iter.next(), modelElement);
                }
            }
        }
        return result;
    }

    public EditPart requireEditPart(EditPart scope, EObject modelElement) {
        EditPart result = this.findEditPart(scope, modelElement);
        if (result == null) {
            String label = this.getLabel(modelElement);
            Assert.fail((String)String.format("No edit-part found for \"%s\" in %s", label, scope));
        }
        return result;
    }

    public String getLabel(EObject object) {
        String result = null;
        try {
            IItemLabelProvider labels;
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.editor.getServicesRegistry());
            if (domain instanceof AdapterFactoryEditingDomain && (labels = (IItemLabelProvider)((AdapterFactoryEditingDomain)domain).getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class)) != null) {
                result = labels.getText((Object)object);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (result == null) {
            result = String.valueOf(object);
        }
        return result;
    }

    public EditPart findEditPart(String name, Class<? extends NamedElement> type) {
        return this.findEditPart((IDiagramWorkbenchPart)this.getActiveDiagramEditor(), name, type);
    }

    public EditPart findEditPart(IMultiDiagramEditor editor, String name, Class<? extends NamedElement> type) {
        IEditorPart activeEditor = editor.getActiveEditor();
        MatcherAssert.assertThat((String)"No diagram active", (Object)activeEditor, (Matcher)CoreMatchers.instanceOf(DiagramEditor.class));
        return this.findEditPart((IDiagramWorkbenchPart)((DiagramEditor)activeEditor), name, type);
    }

    public EditPart findEditPart(IDiagramWorkbenchPart editor, String name, Class<? extends NamedElement> type) {
        EditPart result = null;
        UnmodifiableIterator views = Iterators.filter((Iterator)editor.getDiagram().eAllContents(), View.class);
        while (views.hasNext()) {
            View next = (View)views.next();
            EObject element = next.getElement();
            if (!type.isInstance(element) || !name.equals(type.cast(element).getName())) continue;
            result = (EditPart)editor.getDiagramGraphicalViewer().getEditPartRegistry().get(next);
            break;
        }
        return result;
    }

    public void select(EditPart editPart) {
        editPart.getViewer().getSelectionManager().appendSelection(editPart);
    }

    public void deselect(EditPart editPart) {
        editPart.getViewer().getSelectionManager().deselect(editPart);
    }

    public void move(GraphicalEditPart editPart, Point newLocation) {
        ChangeBoundsRequest move = new ChangeBoundsRequest((Object)"move");
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds();
        move.setEditParts((EditPart)editPart);
        move.setConstrainedMove(false);
        move.setMoveDelta(PapyrusEditorFixture.at(newLocation.x() - bounds.x(), newLocation.y() - bounds.y()));
        this.execute(editPart.getCommand((Request)move));
    }

    public void resize(GraphicalEditPart editPart, Dimension newSize) {
        ChangeBoundsRequest resize = new ChangeBoundsRequest((Object)"resize");
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds();
        resize.setEditParts((EditPart)editPart);
        resize.setResizeDirection(12);
        resize.setCenteredResize(false);
        resize.setConstrainedResize(false);
        resize.setSizeDelta(PapyrusEditorFixture.sized(newSize.width() - bounds.width(), newSize.height() - bounds.height()));
        this.execute(editPart.getCommand((Request)resize));
    }

    public void execute(org.eclipse.gef.commands.Command command) {
        MatcherAssert.assertThat((String)"No command", (Object)command, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)command, CommandMatchers.GEF.canExecute());
        this.getActiveDiagramEditor().getDiagramEditDomain().getDiagramCommandStack().execute(command);
        this.flushDisplayEvents();
    }

    @Override
    public void execute(Command command) {
        super.execute(command);
        this.flushDisplayEvents();
    }

    @Override
    public IStatus execute(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) {
        IStatus result = super.execute(operation, monitor, info);
        this.flushDisplayEvents();
        return result;
    }

    @Override
    public void undo() {
        super.undo();
        this.flushDisplayEvents();
    }

    @Override
    public void redo() {
        super.redo();
        this.flushDisplayEvents();
    }

    public PaletteViewer getPalette() {
        return this.getPalette((IDiagramWorkbenchPart)this.getActiveDiagramEditor());
    }

    public PaletteViewer getPalette(IMultiDiagramEditor editor) {
        IEditorPart activeEditor = editor.getActiveEditor();
        MatcherAssert.assertThat((String)"No diagram active", (Object)activeEditor, (Matcher)CoreMatchers.instanceOf(DiagramEditor.class));
        return this.getPalette((IDiagramWorkbenchPart)((DiagramEditor)activeEditor));
    }

    public PaletteViewer getPalette(IDiagramWorkbenchPart editor) {
        return editor.getDiagramEditPart().getViewer().getEditDomain().getPaletteViewer();
    }

    public void flushDisplayEvents() {
        while (true) {
            try {
                while (Display.getCurrent() == null || Display.getCurrent().readAndDispatch()) {
                }
            }
            catch (Exception e) {
                Bundle testBundle = FrameworkUtil.getBundle(this.testClass == null ? PapyrusEditorFixture.class : this.testClass);
                Platform.getLog((Bundle)testBundle).log((IStatus)new Status(4, testBundle.getSymbolicName(), "Uncaught exception in display runnable.", (Throwable)e));
                continue;
            }
            break;
        }
    }

    public IViewPart getView(String id, boolean open) {
        IViewPart result = null;
        IWorkbenchPage wbPage = this.getWorkbenchPage();
        try {
            try {
                result = wbPage.findView(id);
                if (result == null && open) {
                    result = wbPage.showView(id);
                }
                if (result != null) {
                    result.getSite().getPage().activate((IWorkbenchPart)result);
                    this.flushDisplayEvents();
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to show a view: " + id));
                this.flushDisplayEvents();
            }
        }
        finally {
            this.flushDisplayEvents();
        }
        return result;
    }

    public void save() {
        this.save((ISaveablePart)this.getEditor());
    }

    public void save(ISaveablePart part) {
        if (part.isDirty()) {
            try {
                try {
                    part.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Failed to save editor/view: " + e.getLocalizedMessage()));
                    this.flushDisplayEvents();
                }
            }
            finally {
                this.flushDisplayEvents();
            }
        }
    }

    public void saveAll() {
        try {
            IWorkbenchPage page = this.editor.getSite().getPage();
            page.saveAllEditors(false);
        }
        finally {
            this.flushDisplayEvents();
        }
    }

    public void splitEditorArea(IEditorPart editorToMove, boolean splitHorizontally) {
        MPart editorPart = (MPart)editorToMove.getSite().getService(MPart.class);
        EModelService modelService = (EModelService)editorPart.getContext().get(EModelService.class);
        MPartStack oldStack = (MPartStack)modelService.getContainer((MUIElement)editorPart);
        MPartStack newStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        modelService.insert((MPartSashContainerElement)newStack, (MPartSashContainerElement)oldStack, splitHorizontally ? 3 : 1, 0.5f);
        newStack.getChildren().add(editorPart);
        this.activate((IWorkbenchPart)editorToMove);
    }

    public List<IWorkbenchPart> getPartStack(IWorkbenchPart part) {
        MPart mpart = (MPart)part.getSite().getService(MPart.class);
        EModelService modelService = (EModelService)mpart.getContext().get(EModelService.class);
        MPartStack stack = (MPartStack)modelService.getContainer((MUIElement)mpart);
        ArrayList result = Lists.newArrayListWithCapacity((int)stack.getChildren().size());
        for (MPart next : Iterables.filter((Iterable)stack.getChildren(), MPart.class)) {
            IWorkbenchPart wbPart = (IWorkbenchPart)next.getContext().get(IWorkbenchPart.class);
            if (wbPart == null) continue;
            result.add(wbPart);
        }
        return result;
    }

    protected final boolean hasRequiredViews() {
        return this.getRequiredViews() != null;
    }

    protected final ShowView getRequiredViews() {
        ShowView result = (ShowView)this.testDescription.getAnnotation(ShowView.class);
        if (result == null) {
            Class<?> clazz = this.testClass;
            while (result == null && clazz != null && clazz != Object.class) {
                result = clazz.getAnnotation(ShowView.class);
                clazz = clazz.getSuperclass();
            }
        }
        return result;
    }

    protected void openRequiredViews() {
        IWorkbenchPage page = this.getWorkbenchPage();
        for (ShowViewDescriptor next : ShowViewDescriptor.getDescriptors(this.getRequiredViews())) {
            IViewPart part = page.findView(next.viewID());
            if (part != null) continue;
            try {
                part = page.showView(next.viewID());
                this.movePartRelativeTo((IWorkbenchPart)part, next.relativeTo(), next.location());
                if (this.viewsToClose == null) {
                    this.viewsToClose = Lists.newArrayListWithExpectedSize((int)1);
                }
                this.viewsToClose.add(part);
            }
            catch (PartInitException e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open required view: " + e.getLocalizedMessage()));
            }
        }
        this.flushDisplayEvents();
    }

    private void movePartRelativeTo(IWorkbenchPart part, String relativeTo, int where) {
        MPart mPart = (MPart)part.getSite().getService(MPart.class);
        EModelService modelService = (EModelService)mPart.getContext().get(EModelService.class);
        MUIElement relativePart = modelService.find(relativeTo, (MUIElement)modelService.getTopLevelWindowFor((MUIElement)mPart));
        if (relativePart instanceof MPartSashContainerElement) {
            MPart toMove = mPart;
            MPlaceholder placeHolder = mPart.getCurSharedRef();
            if (placeHolder != null) {
                toMove = placeHolder;
            }
            if (where < 0) {
                MPart relativeMPart;
                if (relativePart instanceof MPart && (relativeMPart = (MPart)relativePart).getCurSharedRef() != null) {
                    relativePart = relativeMPart.getCurSharedRef();
                }
                relativePart.getParent().getChildren().add(toMove);
            } else {
                MPartStack newStack = (MPartStack)modelService.createModelElement(MPartStack.class);
                newStack.getChildren().add(toMove);
                modelService.insert((MPartSashContainerElement)newStack, (MPartSashContainerElement)relativePart, where, 0.3f);
            }
        }
    }

    protected void closeRequiredViews() {
        if (this.viewsToClose != null) {
            for (IViewPart closeMe : this.viewsToClose) {
                closeMe.getSite().getPage().hideView(closeMe);
            }
            this.viewsToClose = null;
            this.flushDisplayEvents();
        }
    }

    public PreferencesHint getPreferencesHint() {
        RootEditPart rootEditPart;
        PreferencesHint result = PreferencesHint.USE_DEFAULTS;
        if (this.activeDiagramEditor != null && (rootEditPart = this.activeDiagramEditor.getDiagramGraphicalViewer().getRootEditPart()) instanceof IDiagramPreferenceSupport) {
            result = ((IDiagramPreferenceSupport)rootEditPart).getPreferencesHint();
        }
        return result;
    }

    public void ensurePapyrusPerspective() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String papyrus = "org.eclipse.papyrus.infra.core.perspective";
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IPerspectiveDescriptor perspective = activePage.getPerspective();
                if (!"org.eclipse.papyrus.infra.core.perspective".equals(perspective.getId()) && (perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.eclipse.papyrus.infra.core.perspective")) != null) {
                    activePage.setPerspective(perspective);
                    PapyrusEditorFixture.this.flushDisplayEvents();
                }
            }
        });
    }

    public EditPart createShape(EditPart parent, IElementType type, Point location, Dimension size) {
        CreateViewRequest request = CreateViewRequestFactory.getCreateShapeRequest((IElementType)type, (PreferencesHint)((IGraphicalEditPart)parent).getDiagramPreferencesHint());
        request.setLocation(location);
        request.setSize(size);
        EditPart target = parent.getTargetEditPart((Request)request);
        MatcherAssert.assertThat((String)"No target edit part", (Object)target, (Matcher)CoreMatchers.notNullValue());
        org.eclipse.gef.commands.Command command = target.getCommand((Request)request);
        this.execute(command);
        return this.getNewEditPart(parent, request.getViewDescriptors());
    }

    private EditPart getNewEditPart(EditPart context, Collection<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        return viewDescriptors.stream().map(desc -> desc.getAdapter(View.class)).map(View.class::cast).filter(Objects::nonNull).map(view -> DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)context)).filter(Objects::nonNull).findAny().orElseGet(PapyrusEditorFixture.failOnAbsence("Could not find newly created edit-part"));
    }

    public EditPart createShape(IElementType type, Point location, Dimension size) {
        EditPartViewer viewer = this.getActiveDiagram().getViewer();
        class MyTool
        extends AspectUnspecifiedTypeCreationTool {
            private Collection<? extends CreateViewRequest.ViewDescriptor> results;

            MyTool(IElementType iElementType) {
                super(Collections.singletonList(iElementType));
                this.results = Collections.emptyList();
            }

            protected Request getTargetRequest() {
                return super.getTargetRequest();
            }

            protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
                super.selectAddedObject(viewer, objects);
                this.results = objects.stream().filter(CreateViewRequest.ViewDescriptor.class::isInstance).map(CreateViewRequest.ViewDescriptor.class::cast).collect(Collectors.toList());
            }

            Collection<? extends CreateViewRequest.ViewDescriptor> getResults() {
                return this.results;
            }
        }
        MyTool tool = new MyTool(type);
        Event mouse = new Event();
        mouse.display = this.editor.getSite().getShell().getDisplay();
        mouse.widget = viewer.getControl();
        mouse.button = 1;
        mouse.x = location.x();
        mouse.y = location.y();
        viewer.getEditDomain().setActiveTool((Tool)tool);
        tool.setViewer(viewer);
        mouse.type = 3;
        tool.mouseDown(new MouseEvent(mouse), viewer);
        this.flushDisplayEvents();
        if (size == null) {
            mouse.type = 4;
            tool.mouseUp(new MouseEvent(mouse), viewer);
        } else {
            mouse.type = 5;
            mouse.x = location.x() + size.width();
            mouse.y = location.y() + size.height();
            tool.mouseDrag(new MouseEvent(mouse), viewer);
            this.flushDisplayEvents();
            mouse.type = 4;
            tool.mouseUp(new MouseEvent(mouse), viewer);
        }
        this.flushDisplayEvents();
        return this.getNewEditPart((EditPart)this.getActiveDiagram(), tool.getResults());
    }

    public static Point at(int x, int y) {
        return new Point(x, y);
    }

    public static Dimension sized(int width, int height) {
        return new Dimension(width, height);
    }

    public void delete(EditPart ... editPart) {
        org.eclipse.gef.commands.Command delete = Stream.of(editPart).map(ep -> ep.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false)))).reduce(org.eclipse.gef.commands.Command::chain).orElseThrow(IllegalArgumentException::new);
        this.execute(delete);
    }

    private static final class ShowViewDescriptor {
        private static final String DEFAULT_RELATIVE_TO = "org.eclipse.ui.editorss";
        private static final ShowView.Location DEFAULT_LOCATION_EDITORS = ShowView.Location.RIGHT;
        private static final ShowView.Location DEFAULT_LOCATION_VIEW = ShowView.Location.STACKED;
        private final String viewID;
        private final String relativeTo;
        private final ShowView.Location location;

        private ShowViewDescriptor(ShowView annotation, int index) {
            this.viewID = annotation.value()[index];
            String[] relativeTo = annotation.relativeTo();
            this.relativeTo = relativeTo.length == 0 ? null : (relativeTo.length == 1 ? relativeTo[0] : relativeTo[index]);
            ShowView.Location[] location = annotation.location();
            this.location = location.length == 0 ? null : (location.length == 1 ? location[0] : location[index]);
        }

        static Iterable<ShowViewDescriptor> getDescriptors(ShowView annotation) {
            ImmutableList.Builder result = ImmutableList.builder();
            String[] ids = annotation.value();
            int i = 0;
            while (i < ids.length) {
                result.add((Object)new ShowViewDescriptor(annotation, i));
                ++i;
            }
            return result.build();
        }

        String viewID() {
            return this.viewID;
        }

        String relativeTo() {
            return this.relativeTo != null ? this.relativeTo : DEFAULT_RELATIVE_TO;
        }

        int location() {
            return (this.location != null ? this.location : (this.relativeTo == null ? DEFAULT_LOCATION_EDITORS : DEFAULT_LOCATION_VIEW)).toModelServiceLocation();
        }
    }
}

