/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.selection;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.util.SelectInDiagramHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class PapyrusRubberbandSelectionTool
extends AbstractTool {
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private int mode;
    private Figure marqueeRectangleFigure;
    private Set<EditPart> allChildren = new HashSet<EditPart>();
    private List<EditPart> selectedEditParts;
    private Request targetRequest;
    private Point feedBackStartLocation = null;
    private WeakReference<?> weakReference;
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    public static final int BEHAVIOR_OBJECT_INCLUDED = new Integer(1);
    public static final int BEHAVIOR_OBJECT_TOUCHED = new Integer(2);
    public static final int DEFAULT_MARQUEE_BEHAVIOR = BEHAVIOR_OBJECT_INCLUDED;
    private int marqueeBehavior = DEFAULT_MARQUEE_BEHAVIOR;
    public static final boolean DEFAULT_SELECT_NODES = true;
    public static final boolean DEFAULT_SELECT_LABELS = true;
    public static final boolean DEFAULT_SELECT_CONNECTIONS = true;
    private boolean selectNodes = true;
    private boolean selectLabels = true;
    private boolean selectConnections = true;

    public PapyrusRubberbandSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    public PapyrusRubberbandSelectionTool(int behavior) {
        this();
        this.setMarqueeBehavior(behavior);
    }

    public PapyrusRubberbandSelectionTool(int behavior, boolean nodeSelectable, boolean labelSelectable, boolean connectionSelectable) {
        this(behavior);
        this.setSelectNodes(nodeSelectable);
        this.setSelectLabels(labelSelectable);
        this.setSelectConnections(connectionSelectable);
    }

    public boolean isSelectNodes() {
        return this.selectNodes;
    }

    public void setSelectNodes(boolean selectNodes) {
        this.selectNodes = selectNodes;
    }

    public boolean isSelectLabels() {
        return this.selectLabels;
    }

    public void setSelectLabels(boolean selectLabels) {
        this.selectLabels = selectLabels;
    }

    public boolean isSelectConnections() {
        return this.selectConnections;
    }

    public void setSelectConnections(boolean selectConnections) {
        this.selectConnections = selectConnections;
    }

    private List calculateNewSelection() {
        ArrayList<EditPart> newSelections = new ArrayList<EditPart>();
        for (EditPart child : this.getAllChildren()) {
            if (!child.isSelectable() || child.getTargetEditPart(MARQUEE_REQUEST) != child || !this.isPartOfMarqueeSelection(this.marqueeBehavior, child)) continue;
            if (this.isNode(child) && this.isSelectNodes()) {
                newSelections.add(child);
                continue;
            }
            if (this.isLabel(child) && this.isSelectLabels()) {
                newSelections.add(child);
                continue;
            }
            if (!this.isConnection(child) || !this.isSelectConnections()) continue;
            newSelections.add(child);
        }
        return newSelections;
    }

    private boolean isNode(EditPart editPart) {
        return editPart instanceof ShapeEditPart;
    }

    private boolean isLabel(EditPart editPart) {
        return editPart instanceof LabelEditPart;
    }

    private boolean isConnection(EditPart editPart) {
        return editPart instanceof ConnectionEditPart;
    }

    private boolean isPartOfMarqueeSelection(int marqueeBehaviorType, EditPart editPart) {
        boolean isInside = false;
        boolean isTouched = false;
        boolean isPartOfSelection = false;
        IFigure figure = ((GraphicalEditPart)editPart).getFigure();
        Rectangle marqueeBounds = this.getMarqueeBounds();
        Rectangle figureRectangle = editPart instanceof ConnectionEditPart ? ((Connection)figure).getPoints().getBounds().getCopy() : figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)figureRectangle);
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)figureRectangle);
        isInside = marqueeBounds.contains(figureRectangle.getTopLeft()) && marqueeBounds.contains(figureRectangle.getBottomRight());
        isTouched = this.isTouchedByMarquee(marqueeBounds, figureRectangle);
        if (marqueeBehaviorType == BEHAVIOR_OBJECT_INCLUDED) {
            isPartOfSelection = isInside;
        } else if (marqueeBehaviorType == BEHAVIOR_OBJECT_TOUCHED) {
            isPartOfSelection = isInside || isTouched;
        }
        return isPartOfSelection;
    }

    private boolean isTouchedByMarquee(Rectangle marqueeBounds, Rectangle figureBounds) {
        return figureBounds.intersects(marqueeBounds);
    }

    public int getMarqueeBehavior() {
        return this.marqueeBehavior;
    }

    public void setMarqueeBehavior(int marqueeBehavior) {
        this.marqueeBehavior = marqueeBehavior;
    }

    protected Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren = new HashSet<EditPart>();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
        this.feedBackStartLocation = null;
    }

    protected void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        ListIterator<EditPart> oldEditParts = this.selectedEditParts.listIterator();
        while (oldEditParts.hasNext()) {
            EditPart editPart = oldEditParts.next();
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private HashSet<EditPart> getAllChildren(EditPart editPart, HashSet<EditPart> currentSelection) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            currentSelection.add((EditPart)child);
            this.getAllChildren((EditPart)child, currentSelection);
            List sourceConnections = child.getSourceConnections();
            List targetConnections = child.getTargetConnections();
            int j = 0;
            while (j < sourceConnections.size()) {
                currentSelection.add((EditPart)((GraphicalEditPart)sourceConnections.get(j)));
                this.getAllChildren((EditPart)sourceConnections.get(j), currentSelection);
                ++j;
            }
            int k = 0;
            while (k < targetConnections.size()) {
                currentSelection.add((EditPart)((GraphicalEditPart)targetConnections.get(k)));
                this.getAllChildren((EditPart)targetConnections.get(k), currentSelection);
                ++k;
            }
            ++i;
        }
        return currentSelection;
    }

    private Set<EditPart> getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.allChildren = this.getAllChildren(this.getCurrentViewer().getContents(), new HashSet<EditPart>());
        }
        return this.allChildren;
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Marquee Tool";
    }

    protected IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private Rectangle getMarqueeBounds() {
        if (this.getMarqueeFeedbackFigure() == null) {
            return new Rectangle();
        }
        Rectangle rect = new Rectangle();
        if (this.feedBackStartLocation == null) {
            rect = this.getMarqueeSelectionRectangle();
            this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
            this.feedBackStartLocation = rect.getLocation();
            return rect;
        }
        Point location = this.getLocation().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)location);
        rect = new Rectangle(this.feedBackStartLocation, location);
        return rect;
    }

    private int getSelectionMode() {
        return this.mode;
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isControlKeyDown()) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            }
            this.clearFocus();
        }
        return true;
    }

    private void clearFocus() {
        EditPart focusPart = this.getCurrentViewer().getFocusEditPart();
        if (focusPart != null) {
            this.getCurrentViewer().setFocus(this.getCurrentViewer().getContents());
        }
    }

    protected void handleFinished() {
        this.getCurrentViewer().setFocus(null);
        super.handleFinished();
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.performMarqueeSelect();
            this.eraseMarqueeFeedback();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateNewSelection();
            this.showTargetFeedback();
            SelectInDiagramHelper.exposeLocation((FigureCanvas)((FigureCanvas)this.getCurrentViewer().getControl()), (Point)this.getLocation());
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        return this.getCurrentViewer().getKeyHandler() != null && this.getCurrentViewer().getKeyHandler().keyPressed(e);
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        List newSelections = this.calculateNewSelection();
        if (this.getSelectionMode() == 2) {
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                viewer.appendSelection(editPart);
                ++i;
            }
        } else if (this.getSelectionMode() == 1) {
            ArrayList<EditPart> selected = new ArrayList<EditPart>(viewer.getSelectedEditParts());
            int i = 0;
            while (i < newSelections.size()) {
                EditPart editPart = (EditPart)newSelections.get(i);
                if (editPart.getSelected() != 0) {
                    selected.remove(editPart);
                } else {
                    selected.add(editPart);
                }
                ++i;
            }
            viewer.setSelection((ISelection)new StructuredSelection(selected));
        } else {
            viewer.setSelection((ISelection)new StructuredSelection(newSelections));
        }
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(Cursors.CROSS);
        } else {
            this.setDefaultCursor(Cursors.NO);
        }
        if (viewer != null) {
            this.weakReference = new WeakReference<EditPartViewer>(viewer);
        }
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    private void showMarqueeFeedback() {
        this.getMarqueeFeedbackFigure().setBounds(this.getMarqueeBounds());
    }

    protected void showTargetFeedback() {
        int i = 0;
        while (i < this.selectedEditParts.size()) {
            EditPart editPart = this.selectedEditParts.get(i);
            editPart.showTargetFeedback(this.getTargetRequest());
            ++i;
        }
    }

    protected void removeFeedback(IFigure figure) {
        EditPartViewer viewer = this.getCurrentViewer();
        if (viewer == null && this.weakReference != null) {
            viewer = (EditPartViewer)this.weakReference.get();
        }
        if (viewer != null) {
            LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
            if (lm == null) {
                return;
            }
            lm.getLayer((Object)"Feedback Layer").remove(figure);
        }
    }

    class MarqueeRectangleFigure
    extends Figure {
        private int offset = 0;
        private boolean schedulePaint = true;
        private static final int DELAY = 110;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle graphicBounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, graphicBounds.width - 1, 0, graphicBounds.width - 1, graphicBounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = graphicBounds.height - 1;
            points[4] = graphicBounds.width - 1;
            points[5] = graphicBounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    @Override
                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = MarqueeRectangleFigure.this;
                        marqueeRectangleFigure.offset = marqueeRectangleFigure.offset + 1;
                        if (MarqueeRectangleFigure.this.offset > 5) {
                            MarqueeRectangleFigure.this.offset = 0;
                        }
                        MarqueeRectangleFigure.this.schedulePaint = true;
                        MarqueeRectangleFigure.this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

