/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.diagram.parametric.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml14.diagram.parametric.Activator;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.UMLPackage;

public class ConstraintBlockParameterCreationCommand
extends AbstractCommand {
    protected IGraphicalEditPart targetEditPart;
    protected EObject targetElement;
    protected EObject typeElement;
    protected Point point;
    protected CreateElementCommand propertyCreationCommand;

    public ConstraintBlockParameterCreationCommand(String label, IGraphicalEditPart targetEditPart, EObject targetElement, EObject typeElement, Point point) {
        super(label);
        this.targetEditPart = targetEditPart;
        this.targetElement = targetElement;
        this.typeElement = typeElement;
        this.point = point;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CreateElementRequest createPropertyCommand = new CreateElementRequest(this.targetElement, (IElementType)UMLElementTypes.PROPERTY);
        this.propertyCreationCommand = new CreateElementCommand(createPropertyCommand);
        this.propertyCreationCommand.execute(progressMonitor, info);
        CommandResult commandResult = this.propertyCreationCommand.getCommandResult();
        if (commandResult != null && commandResult.getStatus().isOK()) {
            EObject createdProperty = this.propertyCreationCommand.getNewElement();
            createdProperty.eSet((EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)this.typeElement);
            ISpecializationType type = (ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.sysmldi.ConstraintPropertyComposite");
            View notationView = this.targetEditPart.getNotationView();
            String semanticHint = ((IHintedType)type).getSemanticHint();
            Node node = ViewService.createNode((View)notationView, (EObject)createdProperty, (String)semanticHint, (PreferencesHint)((GraphicalEditPart)this.targetEditPart).getDiagramPreferencesHint());
            if (node == null) {
                Activator.log(2, "Impossible to create the view " + semanticHint);
            } else if (this.point != null && node.getLayoutConstraint() instanceof Bounds) {
                IFigure parentFigure = this.targetEditPart.getFigure().getParent();
                while (parentFigure != null) {
                    this.point.translate(-(parentFigure.getBounds().x + parentFigure.getInsets().left), -(parentFigure.getBounds().y + parentFigure.getInsets().top));
                    parentFigure = parentFigure.getParent();
                }
                ((Bounds)node.getLayoutConstraint()).setX(this.point.x);
                ((Bounds)node.getLayoutConstraint()).setY(this.point.y);
            }
        }
        return commandResult;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.propertyCreationCommand != null && this.propertyCreationCommand.canRedo()) {
            this.propertyCreationCommand.redo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.propertyCreationCommand != null && this.propertyCreationCommand.canUndo()) {
            this.propertyCreationCommand.undo(progressMonitor, info);
        }
        return CommandResult.newOKCommandResult();
    }
}

