/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.team.core.synchronize.SyncInfo;

public class SyncInfoStatistics {
    protected Map<Integer, Long> stats = new HashMap<Integer, Long>();

    public void add(SyncInfo info) {
        Long count = this.stats.get(info.getKind());
        if (count == null) {
            count = 0L;
        }
        this.stats.put(info.getKind(), count + 1L);
    }

    public void remove(SyncInfo info) {
        Integer kind = info.getKind();
        Long count = this.stats.get(kind);
        if (count != null) {
            long newCount = count.intValue() - 1;
            if (newCount > 0L) {
                this.stats.put(kind, newCount);
            } else {
                this.stats.remove(kind);
            }
        }
    }

    public long countFor(int kind, int mask) {
        if (mask == 0) {
            Long count = this.stats.get(kind);
            return count == null ? 0L : count;
        }
        Iterator<Integer> it = this.stats.keySet().iterator();
        long count = 0L;
        while (it.hasNext()) {
            Integer key = it.next();
            if ((key & mask) != kind) continue;
            count += (long)this.stats.get(key).intValue();
        }
        return count;
    }

    public void clear() {
        this.stats.clear();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (Integer kind : this.stats.keySet()) {
            out.append(String.valueOf(SyncInfo.kindToString(kind)) + ": " + this.stats.get(kind) + "\n");
        }
        return out.toString();
    }
}

