/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeNameUtil {
    public static String getCollectionTypeName(String name) {
        int index = name.indexOf(91);
        if (index == -1) {
            return null;
        }
        if (index == 0 && name.startsWith("[L")) {
            return "List";
        }
        if (name.endsWith("]")) {
            if (name.charAt(name.length() - 2) == '[') {
                return "List";
            }
            if (index == 0 && name.startsWith("L", 1)) {
                return name.substring(2, name.length() - 1);
            }
        }
        return name.substring(0, index);
    }

    public static String getTypeName(String name) {
        int index = name.indexOf(91);
        if (index == -1) {
            int end = name.lastIndexOf(33);
            if (end == -1) {
                return name;
            }
            return name.substring(end + 1);
        }
        if (name.endsWith("]")) {
            if (name.charAt(name.length() - 2) == '[') {
                return name.substring(0, name.length() - 2);
            }
            int end = name.lastIndexOf(33);
            if (end == -1) {
                return name.substring(index + 1, name.length() - 1);
            }
            return name.substring(end + 1, name.length() - 1);
        }
        return null;
    }

    public static String getName(Class<?> class1) {
        return TypeNameUtil.convertJavaTypeName(class1.getName());
    }

    public static String withoutLastSegment(String fqn) {
        int index = fqn.lastIndexOf("::");
        if (index == -1) {
            return null;
        }
        return fqn.substring(0, index);
    }

    public static String getLastSegment(String fqn) {
        int index = fqn.lastIndexOf("::");
        if (index == -1) {
            return fqn;
        }
        return fqn.substring(index + "::".length());
    }

    public static String getSimpleName(String fqn) {
        String ct = TypeNameUtil.getCollectionTypeName(fqn);
        String inner = TypeNameUtil.getLastSegment(TypeNameUtil.getTypeName(fqn));
        StringBuffer sb = new StringBuffer();
        if (ct != null) {
            sb.append(ct).append('[');
        }
        sb.append(inner);
        if (ct != null) {
            sb.append(']');
        }
        return sb.toString();
    }

    public static String getPackage(String insertString) {
        if (insertString == null || insertString.trim().length() == 0) {
            return null;
        }
        int index = insertString.lastIndexOf("::");
        if (index != -1) {
            return insertString.substring(0, index);
        }
        return null;
    }

    public static String convertJavaTypeName(String javaTypeName) {
        if (javaTypeName == null) {
            return null;
        }
        int index = javaTypeName.indexOf(46);
        if (index == -1) {
            return javaTypeName;
        }
        int length = javaTypeName.length();
        StringBuilder result = new StringBuilder(length + 8);
        int start = 0;
        while (index != -1) {
            result.append(javaTypeName, start, index);
            result.append("::");
            start = index + 1;
            index = javaTypeName.indexOf(46, start);
        }
        result.append(javaTypeName, start, length);
        return result.toString();
    }
}

