/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.trace.internal.datamodel.TracingComponent;
import org.eclipse.ui.trace.internal.datamodel.TracingComponentDebugOption;

public class TracingComponentViewerFilter
extends PatternFilter {
    private final Map<TracingComponent, Boolean> visibleTracingComponentsCache = new HashMap<TracingComponent, Boolean>();
    private final Map<TracingComponentDebugOption, Boolean> visibleTracingDebugOptions = new HashMap<TracingComponentDebugOption, Boolean>();

    public void setPattern(String patternString) {
        super.setPattern(patternString);
        this.visibleTracingComponentsCache.clear();
        this.visibleTracingDebugOptions.clear();
    }

    private void forceVisibleDebugOptions(TracingComponentDebugOption[] options) {
        TracingComponentDebugOption[] tracingComponentDebugOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            TracingComponentDebugOption option = tracingComponentDebugOptionArray[n2];
            if (option.hasChildren()) {
                this.forceVisibleDebugOptions(option.getChildren());
            }
            this.visibleTracingDebugOptions.put(option, Boolean.TRUE);
            ++n2;
        }
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        boolean isVisible = false;
        if (element instanceof TracingComponent) {
            TracingComponent component = (TracingComponent)element;
            boolean textMatches = super.isLeafMatch(viewer, (Object)component);
            if (textMatches) {
                isVisible = true;
                this.visibleTracingComponentsCache.put(component, Boolean.TRUE);
                this.forceVisibleDebugOptions(component.getChildren());
            } else {
                isVisible = super.isElementVisible(viewer, element);
                this.visibleTracingComponentsCache.put(component, isVisible);
            }
        } else if (element instanceof TracingComponentDebugOption) {
            Boolean enabled = this.visibleTracingDebugOptions.get(element);
            if (enabled != null) {
                isVisible = enabled;
            } else {
                isVisible = super.isLeafMatch(viewer, element);
                if (!isVisible) {
                    isVisible = super.isParentMatch(viewer, element);
                }
            }
        }
        return isVisible;
    }
}

