/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BundleSigningInfo {
    private Composite composite;
    private Text date;
    private StyledText certificate;
    private AboutBundleData data;

    public void setData(AboutBundleData data) {
        this.data = data;
        this.startJobs();
    }

    public Control createContents(Composite parent) {
        this.composite = new Composite(parent, 2048);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        Label label = new Label(this.composite, 0);
        label.setText(WorkbenchMessages.BundleSigningTray_Signing_Date);
        GridData data = new GridData(4, 1, true, false);
        this.date = new Text(this.composite, 8);
        GC gc = new GC((Drawable)this.date);
        gc.setFont(JFaceResources.getDialogFont());
        Point size = gc.stringExtent(DateFormat.getDateTimeInstance().format(new Date()));
        data.widthHint = size.x;
        gc.dispose();
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setLayoutData((Object)data);
        label = new Label(this.composite, 0);
        label.setText(WorkbenchMessages.BundleSigningTray_Signing_Certificate);
        data = new GridData(1, 1, true, false);
        data.horizontalSpan = 2;
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        this.certificate = new StyledText(this.composite, 74);
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.certificate.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this.composite);
        this.startJobs();
        return this.composite;
    }

    private void startJobs() {
        if (!this.isOpen()) {
            return;
        }
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        BundleContext bundleContext = WorkbenchPlugin.getDefault().getBundleContext();
        ServiceReference factoryRef = bundleContext.getServiceReference(SignedContentFactory.class.getName());
        if (factoryRef == null) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.BundleSigningTray_Cant_Find_Service), 1);
            return;
        }
        SignedContentFactory contentFactory = (SignedContentFactory)bundleContext.getService(factoryRef);
        if (contentFactory == null) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, WorkbenchMessages.BundleSigningTray_Cant_Find_Service), 1);
            return;
        }
        AboutBundleData myData = this.data;
        Job signerJob = Job.create((String)NLS.bind((String)WorkbenchMessages.BundleSigningTray_Determine_Signer_For, (Object)myData.getId()), monitor -> {
            try {
                String dateText;
                String signerText;
                if (myData != this.data) {
                    return Status.OK_STATUS;
                }
                SignedContent signedContent = contentFactory.getSignedContent(myData.getBundle());
                if (myData != this.data) {
                    return Status.OK_STATUS;
                }
                SignerInfo[] signers = signedContent.getSignerInfos();
                if (!this.isOpen() && this.data == myData) {
                    return Status.OK_STATUS;
                }
                if (signers.length == 0) {
                    signerText = WorkbenchMessages.BundleSigningTray_Unsigned;
                    dateText = WorkbenchMessages.BundleSigningTray_Unsigned;
                } else {
                    Properties[] certs = this.parseCerts(signers[0].getCertificateChain());
                    if (certs.length == 0) {
                        signerText = WorkbenchMessages.BundleSigningTray_Unknown;
                    } else {
                        StringBuilder buffer = new StringBuilder();
                        Iterator<Map.Entry<Object, Object>> i = certs[0].entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry<Object, Object> entry = i.next();
                            buffer.append(entry.getKey());
                            buffer.append('=');
                            buffer.append(entry.getValue());
                            if (!i.hasNext()) continue;
                            buffer.append('\n');
                        }
                        signerText = buffer.toString();
                    }
                    Date signDate = signedContent.getSigningTime(signers[0]);
                    dateText = signDate != null ? DateFormat.getDateTimeInstance().format(signDate) : WorkbenchMessages.BundleSigningTray_Unknown;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    if (!this.isOpen() && this.data != myData) {
                        return;
                    }
                    this.certificate.setText(signerText);
                    this.date.setText(dateText);
                });
            }
            catch (IOException e1) {
                return new Status(4, WorkbenchPlugin.PI_WORKBENCH, e1.getMessage(), (Throwable)e1);
            }
            catch (GeneralSecurityException e2) {
                return new Status(4, WorkbenchPlugin.PI_WORKBENCH, e2.getMessage(), (Throwable)e2);
            }
            return Status.OK_STATUS;
        });
        signerJob.setSystem(true);
        signerJob.belongsTo((Object)signerJob);
        signerJob.schedule();
        Job cleanup = Job.create((String)WorkbenchMessages.BundleSigningTray_Unget_Signing_Service, monitor -> {
            try {
                Job.getJobManager().join((Object)signerJob, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
            bundleContext.ungetService(factoryRef);
            return Status.OK_STATUS;
        });
        cleanup.setSystem(true);
        cleanup.schedule();
    }

    private boolean isOpen() {
        return this.certificate != null && !this.certificate.isDisposed();
    }

    private Properties[] parseCerts(Certificate[] chain) {
        ArrayList<Properties> certs = new ArrayList<Properties>(chain.length);
        int i = 0;
        while (i < chain.length) {
            Properties cert;
            if (chain[i] instanceof X509Certificate && (cert = this.parseCert(((X509Certificate)chain[i]).getSubjectDN().getName())) != null) {
                certs.add(cert);
            }
            ++i;
        }
        return certs.toArray(new Properties[certs.size()]);
    }

    private Properties parseCert(String certString) {
        StringTokenizer toker = new StringTokenizer(certString, ",");
        Properties cert = new Properties();
        while (toker.hasMoreTokens()) {
            String pair = toker.nextToken();
            int idx = pair.indexOf(61);
            if (idx <= 0 || idx >= pair.length() - 2) continue;
            String key = pair.substring(0, idx).trim();
            String value = pair.substring(idx + 1).trim();
            if (value.length() > 2) {
                if (value.charAt(0) == '\"') {
                    value = value.substring(1);
                }
                if (value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(0, value.length() - 1);
                }
            }
            cert.setProperty(key, value);
        }
        return cert;
    }

    public void dispose() {
        this.composite.dispose();
    }
}

