/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractIdResolver;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TupleTypeManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class PivotIdResolver
extends AbstractIdResolver {
    private static final Logger logger = Logger.getLogger(PivotIdResolver.class);
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull PivotMetamodelManager metamodelManager;

    public PivotIdResolver(@NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory.getMetamodelManager().getCompleteEnvironment());
        this.environmentFactory = environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
    }

    @Override
    protected @NonNull Package addEPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        Package asPackage = (Package)this.nsURI2package.get(nsURI);
        if (asPackage == null) {
            PackageId packageId = IdManager.getPackageId(ePackage);
            asPackage = this.metamodelManager.getASOfEcore(Package.class, (EObject)ePackage);
            if (asPackage == null && (asPackage = this.getPivotlessEPackage(ePackage)) == null) {
                throw new IllegalStateException("EPackage " + ePackage.getName() + " : " + ePackage.getNsURI() + " has no Pivot counterpart.");
            }
            this.nsURI2package.put(nsURI, asPackage);
            if (packageId instanceof RootPackageId) {
                this.roots2package.put(((RootPackageId)packageId).getName(), asPackage);
            }
        }
        return asPackage;
    }

    @Override
    public @NonNull CompleteInheritance getInheritance(@NonNull EClassifier eClassifier) {
        return this.metamodelManager.getInheritance(this.getType(eClassifier));
    }

    protected @Nullable Package getPivotlessEPackage(@NonNull EPackage ePackage) {
        return null;
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        if (value instanceof ElementExtension) {
            Stereotype asStereotype = ((ElementExtension)value).getStereotype();
            return asStereotype != null ? asStereotype : this.metamodelManager.getStandardLibrary().getOclInvalidType();
        }
        return super.getStaticTypeOf(value);
    }

    @Override
    public @NonNull TupleType getTupleType(@NonNull TupleTypeId typeId) {
        TupleTypeManager tupleManager = this.metamodelManager.getCompleteModel().getTupleManager();
        return tupleManager.getTupleType(this, typeId);
    }

    @Override
    public @NonNull Class getType(@NonNull EClassifier eClassifier) {
        CompletePackage completePackage;
        Class pivotType;
        Package asMetamodel;
        String typeName;
        EClassifier eType = eClassifier;
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage == PivotPackage.eINSTANCE && (typeName = eClassifier.getName()) != null && (asMetamodel = this.metamodelManager.getASmetamodel()) != null && (pivotType = (completePackage = this.metamodelManager.getCompletePackage(asMetamodel)).getMemberType(typeName)) != null) {
            return pivotType;
        }
        try {
            Class pivotType2 = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).getASOf(Class.class, (EObject)eType);
            if (pivotType2 != null) {
                return this.metamodelManager.getPrimaryClass(pivotType2);
            }
        }
        catch (ParserException e) {
            logger.error((Object)("Failed to convert '" + eType + "'"), (Throwable)e);
        }
        return this.metamodelManager.getStandardLibrary().getOclInvalidType();
    }

    @Override
    public @NonNull Type getType(@NonNull TypeId typeId, @Nullable Object context) {
        Element type = typeId.accept(this);
        assert (type != null);
        return (Type)type;
    }

    @Override
    public @Nullable Object unboxedValueOf(@Nullable Object boxedValue) {
        if (boxedValue instanceof EnumerationLiteralId) {
            EnumerationLiteral enumerationLiteral = this.visitEnumerationLiteralId((EnumerationLiteralId)boxedValue);
            if (enumerationLiteral instanceof PivotObjectImpl) {
                EObject eTarget = ((PivotObjectImpl)((Object)enumerationLiteral)).getESObject();
                return eTarget;
            }
            return enumerationLiteral;
        }
        return super.unboxedValueOf(boxedValue);
    }

    @Override
    public synchronized @NonNull Package visitNsURIPackageId(@NonNull NsURIPackageId id) {
        String nsURI = id.getNsURI();
        Package nsURIPackage = this.standardLibrary.getNsURIPackage(nsURI);
        if (nsURIPackage != null) {
            return nsURIPackage;
        }
        this.metamodelManager.setAutoLoadASmetamodel(true);
        Package asMetamodel = this.metamodelManager.getASmetamodel();
        if (asMetamodel != null && "http://www.eclipse.org/ocl/2015/Pivot".equals(nsURI)) {
            return asMetamodel;
        }
        nsURIPackage = this.standardLibrary.getNsURIPackage(nsURI);
        if (nsURIPackage != null) {
            return nsURIPackage;
        }
        return super.visitNsURIPackageId(id);
    }

    @Override
    public @Nullable Package visitRootPackageId(@NonNull RootPackageId id) {
        Orphanage orphanage;
        String completeURIorName = id.getName();
        Package rootPackage = this.standardLibrary.getRootPackage(completeURIorName);
        if (rootPackage == null && (rootPackage = NameUtil.getNameable((orphanage = this.metamodelManager.getCompleteModel().getOrphanage()).getOwnedPackages(), completeURIorName)) == null) {
            return null;
        }
        return rootPackage;
    }
}

