/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveCompletePackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.NamedElementImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteClasses;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.NestedCompletePackages;
import org.eclipse.ocl.pivot.internal.complete.PartialPackages;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class CompletePackageImpl
extends NamedElementImpl
implements CompletePackage,
CompletePackageInternal {
    private String nsPrefix;
    private String nsURI;
    protected @Nullable CompleteClasses ownedCompleteClasses;
    protected @Nullable NestedCompletePackages ownedCompletePackages;
    protected final @NonNull PartialPackages partialPackages = new PartialPackages(this);

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.COMPLETE_PACKAGE;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatingComments()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComments()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedExtensions()).basicAdd((Object)otherEnd, msgs);
            }
            case 5: {
                return this.getOwnedCompleteClasses().basicAdd(otherEnd, msgs);
            }
            case 6: {
                return this.getOwnedCompletePackages().basicAdd(otherEnd, msgs);
            }
            case 7: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwningCompleteModel((CompleteModel)otherEnd, msgs);
            }
            case 8: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwningCompletePackage((CompletePackage)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatingComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOwnedAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedExtensions()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return this.getOwnedCompleteClasses().basicRemove(otherEnd, msgs);
            }
            case 6: {
                return this.getOwnedCompletePackages().basicRemove(otherEnd, msgs);
            }
            case 7: {
                return this.basicSetOwningCompleteModel(null, msgs);
            }
            case 8: {
                return this.basicSetOwningCompletePackage(null, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 7: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 6, CompleteModel.class, msgs);
            }
            case 8: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 6, CompletePackage.class, msgs);
            }
        }
        return this.eDynamicBasicRemoveFromContainer(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getOwnedCompleteClasses();
            }
            case 6: {
                return this.getOwnedCompletePackages();
            }
            case 7: {
                return this.getOwningCompleteModel();
            }
            case 8: {
                return this.getOwningCompletePackage();
            }
            case 9: {
                return this.getPartialPackages();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.getOwnedCompleteClasses().clear();
                this.getOwnedCompleteClasses().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getOwnedCompletePackages().clear();
                this.getOwnedCompletePackages().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setOwningCompleteModel((CompleteModel)newValue);
                return;
            }
            case 8: {
                this.setOwningCompletePackage((CompletePackage)newValue);
                return;
            }
            case 9: {
                this.getPartialPackages().clear();
                this.getPartialPackages().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.getOwnedCompleteClasses().clear();
                return;
            }
            case 6: {
                this.getOwnedCompletePackages().clear();
                return;
            }
            case 7: {
                this.setOwningCompleteModel(null);
                return;
            }
            case 8: {
                this.setOwningCompletePackage(null);
                return;
            }
            case 9: {
                this.getPartialPackages().clear();
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.ownedCompleteClasses != null && !this.ownedCompleteClasses.isEmpty();
            }
            case 6: {
                return this.ownedCompletePackages != null && !this.ownedCompletePackages.isEmpty();
            }
            case 7: {
                return this.getOwningCompleteModel() != null;
            }
            case 8: {
                return this.getOwningCompletePackage() != null;
            }
            case 9: {
                return this.partialPackages != null && !this.partialPackages.isEmpty();
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.getOwnedCompleteClass((String)arguments.get(0));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    protected CompletePackageImpl() {
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitCompletePackage(this);
    }

    @Override
    public void assertSamePackage(Package pivotPackage) {
        assert (pivotPackage != null);
        if (this.getOwningCompletePackage() == null) {
            Package parentPackage = pivotPackage.getOwningPackage();
            String typeBasedNsURI = pivotPackage.getURI();
            String serverBasedNsURI = this.getURI();
            if (typeBasedNsURI != null) {
                CompleteModelInternal completeModel = this.getCompleteModel();
                assert (serverBasedNsURI == null || completeModel.getCompletePackageByURI(typeBasedNsURI) == completeModel.getCompletePackageByURI(serverBasedNsURI));
            }
        } else {
            String typeBasedNsURI = pivotPackage.getURI();
            String serverBasedNsURI = this.getURI();
            assert (typeBasedNsURI == serverBasedNsURI || typeBasedNsURI.equals(serverBasedNsURI));
        }
    }

    protected void didAddNestedPackage(@NonNull CompleteModel completeModel, @NonNull Package pivotPackage) {
        this.getPartialPackages().add(pivotPackage);
        if (this.ownedCompleteClasses != null) {
            this.ownedCompleteClasses.didAddPackage(pivotPackage);
        }
    }

    public void didAddClass(@NonNull Class partialClass) {
        if (this.ownedCompleteClasses != null) {
            this.ownedCompleteClasses.didAddClass(partialClass);
        }
    }

    public void didAddNestedPackage(@NonNull Package nestedPackage) {
        this.getOwnedCompletePackages().didAddPackage(nestedPackage);
    }

    public void didAddPartialPackage(@NonNull Package partialPackage) {
        if (this.ownedCompleteClasses != null) {
            this.ownedCompleteClasses.didAddPackage(partialPackage);
        }
    }

    public void didRemoveClass(@NonNull Class partialClass) {
        if (partialClass instanceof PrimitiveType && !(this instanceof PrimitiveCompletePackage)) {
            this.getCompleteModel().getPrimitiveCompletePackage().didRemoveClass(partialClass);
        } else if (this.ownedCompleteClasses != null) {
            this.ownedCompleteClasses.didRemoveClass(partialClass);
        }
    }

    public void didRemoveNestedPackage(@NonNull Package nestedPackage) {
        this.getOwnedCompletePackages().didRemovePackage(nestedPackage);
    }

    public void didRemovePartialPackage(@NonNull Package partialPackage) {
        if (this.ownedCompleteClasses != null) {
            this.ownedCompleteClasses.didRemovePackage(partialPackage);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public @NonNull Iterable<@NonNull Class> getAllClasses() {
        return Iterables.transform(ClassUtil.nullFree(this.getOwnedCompleteClasses()), (Function)new Function<CompleteClass, Class>(){

            public @NonNull Class apply(@NonNull CompleteClass input) {
                return input.getPrimaryClass();
            }
        });
    }

    @Override
    public @NonNull CompleteClassInternal getCompleteClass(@NonNull Class pivotType) {
        return ClassUtil.nonNullState(this.getOwnedCompleteClass(pivotType.getName()));
    }

    @Override
    public @NonNull CompleteInheritanceImpl getCompleteInheritance(@NonNull CompleteClassInternal completeClass) {
        assert (this != this.getCompleteModel().getOrphanCompletePackage());
        return this.getPartialPackages().getCompleteInheritance(completeClass);
    }

    @Override
    public @NonNull CompleteModelInternal getCompleteModel() {
        EObject eContainer = this.eContainer();
        while (eContainer != null) {
            if (eContainer instanceof CompleteModelInternal) {
                return (CompleteModelInternal)eContainer;
            }
            eContainer = eContainer.eContainer();
        }
        throw new IllegalStateException();
    }

    @Override
    public EPackage getEPackage() {
        Iterator iterator = this.getPartialPackages().iterator();
        while (iterator.hasNext()) {
            Package partialPackage = (Package)iterator.next();
            EPackage ePackage = partialPackage.getEPackage();
            if (ePackage == null) continue;
            return ePackage;
        }
        return null;
    }

    @Override
    public int getIndex(Package p1) {
        return this.getPartialPackages().indexOf(p1);
    }

    @Override
    public Class getMemberType(String name) {
        CompleteClassInternal completeClass = name != null ? this.getOwnedCompleteClass(name) : null;
        return completeClass != null ? completeClass.getPrimaryClass() : null;
    }

    @Override
    public String getNsPrefix() {
        return this.nsPrefix;
    }

    @Override
    public CompleteClassInternal getOwnedCompleteClass(String name) {
        return this.getOwnedCompleteClasses().getOwnedCompleteClass(name);
    }

    @Override
    public CompletePackageInternal getOwnedCompletePackage(@Nullable String name) {
        return this.getOwnedCompletePackages().getOwnedCompletePackage(name);
    }

    public @NonNull CompleteClasses getOwnedCompleteClasses() {
        CompleteClasses ownedCompleteClasses2 = this.ownedCompleteClasses;
        if (ownedCompleteClasses2 == null) {
            this.ownedCompleteClasses = ownedCompleteClasses2 = new CompleteClasses(this);
        }
        return ownedCompleteClasses2;
    }

    public @NonNull NestedCompletePackages getOwnedCompletePackages() {
        NestedCompletePackages ownedCompletePackages2 = this.ownedCompletePackages;
        if (ownedCompletePackages2 == null) {
            this.ownedCompletePackages = ownedCompletePackages2 = new NestedCompletePackages(this);
        }
        return ownedCompletePackages2;
    }

    @Override
    public CompleteModel getOwningCompleteModel() {
        if (this.eContainerFeatureID() != 7) {
            return null;
        }
        return (CompleteModel)this.eInternalContainer();
    }

    public NotificationChain basicSetOwningCompleteModel(CompleteModel newOwningCompleteModel, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newOwningCompleteModel, 7, msgs);
        return msgs;
    }

    @Override
    public void setOwningCompleteModel(CompleteModel newOwningCompleteModel) {
        if (newOwningCompleteModel != this.eInternalContainer() || this.eContainerFeatureID() != 7 && newOwningCompleteModel != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newOwningCompleteModel)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwningCompleteModel != null) {
                msgs = ((InternalEObject)newOwningCompleteModel).eInverseAdd((InternalEObject)this, 6, CompleteModel.class, msgs);
            }
            if ((msgs = this.basicSetOwningCompleteModel(newOwningCompleteModel, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newOwningCompleteModel, (Object)newOwningCompleteModel));
        }
    }

    @Override
    public @Nullable CompletePackage getOwningCompletePackage() {
        if (this.eContainerFeatureID() != 8) {
            return null;
        }
        return (CompletePackage)this.eInternalContainer();
    }

    public NotificationChain basicSetOwningCompletePackage(CompletePackage newOwningCompletePackage, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newOwningCompletePackage, 8, msgs);
        return msgs;
    }

    @Override
    public void setOwningCompletePackage(CompletePackage newOwningCompletePackage) {
        if (newOwningCompletePackage != this.eInternalContainer() || this.eContainerFeatureID() != 8 && newOwningCompletePackage != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newOwningCompletePackage)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwningCompletePackage != null) {
                msgs = ((InternalEObject)newOwningCompletePackage).eInverseAdd((InternalEObject)this, 6, CompletePackage.class, msgs);
            }
            if ((msgs = this.basicSetOwningCompletePackage(newOwningCompletePackage, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newOwningCompletePackage, (Object)newOwningCompletePackage));
        }
    }

    @Override
    public @NonNull PartialPackages getPartialPackages() {
        return this.partialPackages;
    }

    @Override
    public final @NonNull Package getPrimaryPackage() {
        Package partialPackage;
        Iterator iterator = this.getPartialPackages().iterator();
        while (iterator.hasNext()) {
            partialPackage = (Package)iterator.next();
            if (partialPackage == null) continue;
            return partialPackage;
        }
        partialPackage = this.getCompleteModel().getStandardLibrary().getOclAnyType().getOwningPackage();
        return ClassUtil.nonNullState(partialPackage);
    }

    @Override
    public @NonNull CompletePackageInternal getRootCompletePackage() {
        EObject eContainer = this.eContainer();
        while (eContainer instanceof CompletePackageInternal) {
            CompletePackageInternal completePackageInternal = (CompletePackageInternal)eContainer;
            if (completePackageInternal.getOwningCompletePackage() == null) {
                return (CompletePackageInternal)eContainer;
            }
            eContainer = eContainer.eContainer();
        }
        return this;
    }

    @Override
    public Type getType(String metatypeName) {
        CompleteClassInternal completeClass = this.getOwnedCompleteClass(metatypeName);
        return completeClass != null ? completeClass.getPrimaryClass() : null;
    }

    @Override
    public String getURI() {
        return this.nsURI;
    }

    @Override
    public void init(String name, @Nullable String nsPrefix, @Nullable String nsURI) {
        this.setName(name);
        this.nsPrefix = nsPrefix;
        this.nsURI = nsURI;
    }
}

