/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.xtext.datatypes.ui.contribution;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.robotics.xtext.datatypes.dTML.XAssignment;
import org.eclipse.papyrus.robotics.xtext.datatypes.ui.internal.DatatypesActivator;
import org.eclipse.papyrus.uml.xtext.integration.AbstractXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.InvalidStringUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.ValueSpecificationAction;

public class ParameterEditorConfigurationContribution
extends AbstractXtextDirectEditorConfiguration {
    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof ValueSpecificationAction) {
            ValueSpecificationAction action = (ValueSpecificationAction)editedObject;
            String invalidStr = InvalidStringUtil.getTextualRepresentation((Element)action);
            if (invalidStr != null) {
                return invalidStr;
            }
            String textToEdit = String.valueOf(action.getName()) + " = ";
            if (action.getValue() instanceof LiteralString) {
                LiteralString ls = (LiteralString)action.getValue();
                textToEdit = String.valueOf(textToEdit) + ls.getValue() + ";";
            }
            return textToEdit;
        }
        return "Unexpected editor object";
    }

    public int getStyle() {
        return 66;
    }

    public Injector getInjector() {
        return DatatypesActivator.getInstance().getInjector("org.eclipse.papyrus.robotics.xtext.datatypes.DTML");
    }

    public ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        TransactionalEditingDomain dom = TransactionUtil.getEditingDomain((EObject)umlObject);
        if (umlObject instanceof ValueSpecificationAction) {
            ValueSpecificationAction vsa = (ValueSpecificationAction)umlObject;
            if (xtextObject instanceof XAssignment) {
                UpdateValueSpecificationCommand updateCommand = new UpdateValueSpecificationCommand(dom, vsa, (XAssignment)xtextObject);
                return updateCommand;
            }
        }
        return null;
    }

    protected static class UpdateValueSpecificationCommand
    extends AbstractTransactionalCommand {
        private ValueSpecificationAction action;
        private XAssignment assign;

        public UpdateValueSpecificationCommand(TransactionalEditingDomain domain, ValueSpecificationAction action, XAssignment assign) {
            super(domain, "Assign LiteralString to UML::ValueSpecificationAction", UpdateValueSpecificationCommand.getWorkspaceFiles((EObject)action));
            this.action = action;
            this.assign = assign;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.assign != null && this.assign.getName() != null && this.assign.getExpression() != null) {
                this.action.setName(this.assign.getName());
                LiteralString ls = null;
                ls = this.action.getValue() instanceof LiteralString ? (LiteralString)this.action.getValue() : (LiteralString)this.action.createValue(null, null, UMLPackage.eINSTANCE.getLiteralString());
                ls.setValue(this.assign.getExpression());
                this.action.setValue((ValueSpecification)ls);
            }
            return CommandResult.newOKCommandResult((Object)this.action);
        }
    }
}

