/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.robotics.safety.riskanalysis.HazardAnalysis;
import org.eclipse.papyrus.robotics.safety.riskanalysis.HazardAnalysisContext;
import org.eclipse.papyrus.robotics.safety.riskanalysis.OccurenceEstimation;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskEstimation;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskIndex;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskanalysisFactory;
import org.eclipse.papyrus.robotics.safety.riskanalysis.RiskanalysisPackage;
import org.eclipse.papyrus.robotics.safety.riskanalysis.impl.HazardAnalysisContextImpl;
import org.eclipse.papyrus.robotics.safety.riskanalysis.impl.HazardAnalysisImpl;

public class RiskanalysisFactoryImpl
extends EFactoryImpl
implements RiskanalysisFactory {
    public static RiskanalysisFactory init() {
        try {
            RiskanalysisFactory theRiskanalysisFactory = (RiskanalysisFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/robotics/safety/riskanalysis/1");
            if (theRiskanalysisFactory != null) {
                return theRiskanalysisFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new RiskanalysisFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createHazardAnalysis();
            }
            case 1: {
                return this.createHazardAnalysisContext();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createOccurenceEstimationFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createRiskEstimationFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createRiskIndexFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertOccurenceEstimationToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertRiskEstimationToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertRiskIndexToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public HazardAnalysis createHazardAnalysis() {
        HazardAnalysisImpl hazardAnalysis = new HazardAnalysisImpl();
        return hazardAnalysis;
    }

    @Override
    public HazardAnalysisContext createHazardAnalysisContext() {
        HazardAnalysisContextImpl hazardAnalysisContext = new HazardAnalysisContextImpl();
        return hazardAnalysisContext;
    }

    public OccurenceEstimation createOccurenceEstimationFromString(EDataType eDataType, String initialValue) {
        OccurenceEstimation result = OccurenceEstimation.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOccurenceEstimationToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RiskEstimation createRiskEstimationFromString(EDataType eDataType, String initialValue) {
        RiskEstimation result = RiskEstimation.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRiskEstimationToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RiskIndex createRiskIndexFromString(EDataType eDataType, String initialValue) {
        RiskIndex result = RiskIndex.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRiskIndexToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public RiskanalysisPackage getRiskanalysisPackage() {
        return (RiskanalysisPackage)this.getEPackage();
    }

    @Deprecated
    public static RiskanalysisPackage getPackage() {
        return RiskanalysisPackage.eINSTANCE;
    }
}

