/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.types.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.commands.CancelCommand;
import org.eclipse.papyrus.robotics.core.commands.PortCommands;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentService;
import org.eclipse.papyrus.robotics.profile.robotics.services.CoordinationService;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ComponentCoordinationPortEditHelperAdvice
extends AbstractEditHelperAdvice {
    private static final String IS_COORD_PORT_ATTRIBUTE = "isCoordinationPort";
    protected EObject source;
    protected EObject target;

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        EReference ref;
        RoboticsContentProvider cpWithWS;
        EnhancedPopupMenu.SubSelect serviceDef;
        Object value;
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Port)) {
            return super.getAfterConfigureCommand(request);
        }
        final Port port = (Port)newElement;
        CompositeCommand compositeCommand = new CompositeCommand("Update component coordination port");
        RecordingCommand applyStereotypeCommand = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                Stereotype cp = StereotypeUtil.apply((Element)port, ComponentPort.class);
                port.setValue(cp, ComponentCoordinationPortEditHelperAdvice.IS_COORD_PORT_ATTRIBUTE, (Object)true);
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)applyStereotypeCommand));
        ICommand associateCSCommand = PortUtils.associateCSCommand(port);
        if (associateCSCommand != null) {
            compositeCommand.add((IUndoableOperation)associateCSCommand);
        }
        if (!((value = (serviceDef = new EnhancedPopupMenu.SubSelect("", (IStructuredContentProvider)(cpWithWS = new RoboticsContentProvider((EObject)port, (IStaticContentProvider)new UMLContentProvider((EObject)port, (EStructuralFeature)(ref = UMLPackage.eINSTANCE.getPort_Provided())), CoordinationService.class, ".servicedef.uml")))).getResult()) instanceof Classifier)) {
            return new CancelCommand((EObject)port);
        }
        final Classifier newType = (Classifier)value;
        SetRequest setNameRequest = new SetRequest((EObject)port, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)"Port");
        ICommand setNameCmd = ElementEditServiceUtils.getCommandProvider((EObject)port).getEditCommand((IEditCommandRequest)setNameRequest);
        compositeCommand.add((IUndoableOperation)setNameCmd);
        CompositeCommand wrapper = new CompositeCommand("wrapper"){
            boolean first;
            {
                super($anonymous0);
                this.first = true;
            }

            public boolean canExecute() {
                if (this.first) {
                    return true;
                }
                return super.canExecute();
            }

            public IStatus execute(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (this.first) {
                    this.add((IUndoableOperation)PortCommands.addProvided(port, (Interface)newType));
                    this.first = false;
                }
                return super.execute(progressMonitor, info);
            }
        };
        compositeCommand.add((IUndoableOperation)wrapper);
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }

    protected ICommand getAfterDestroyDependentsCommand(DestroyDependentsRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Port destruction command");
        EObject destroyElement = request.getElementToDestroy();
        if (!(destroyElement instanceof Port)) {
            return super.getAfterDestroyDependentsCommand(request);
        }
        Port port = (Port)destroyElement;
        Type cs = port.getType();
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)port);
        if (cs != null && StereotypeUtil.isApplied((Element)cs, ComponentService.class) && !PortUtils.isCSDuplicate(port)) {
            for (Dependency dep : cs.getClientDependencies()) {
                DestroyElementRequest destroyDepReq = new DestroyElementRequest((EObject)dep, false);
                ICommand destroyDepCmd = commandProvider.getEditCommand((IEditCommandRequest)destroyDepReq);
                compositeCommand.add((IUndoableOperation)destroyDepCmd);
            }
            DestroyElementRequest destroyCSReq = new DestroyElementRequest((EObject)cs, false);
            ICommand destroyCSCmd = commandProvider.getEditCommand((IEditCommandRequest)destroyCSReq);
            compositeCommand.add((IUndoableOperation)destroyCSCmd);
        }
        return compositeCommand.isEmpty() ? super.getAfterDestroyDependentsCommand(request) : compositeCommand;
    }

    protected ICommand getAfterDuplicateCommand(DuplicateElementsRequest request) {
        return null;
    }
}

