/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.provider.FilterStereotypes;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.uml2.uml.Package;

public class RoboticsContentProvider
extends EncapsulatedContentProvider
implements IStaticContentProvider {
    private static final String EMPTY = "";
    protected static final String MODELS_VIA_PATHMAPS = "Models via pathmaps";
    protected static final String WORKSPACE_MATCHES = "Workspace matches";
    protected static final String MODEL_MATCHES = "Model matches";
    protected String extension;
    protected ResourceSet tempRS;
    protected ResourceSet encapsulatedRS;
    protected Class<? extends EObject> stereotypeFilter;

    public RoboticsContentProvider(EObject context, IStaticContentProvider encapsulated, Class<? extends EObject> stereotypeFilter, String extension) {
        this(context, (IStructuredContentProvider)new FilterStereotypes(encapsulated, stereotypeFilter), extension);
        this.stereotypeFilter = stereotypeFilter;
    }

    public RoboticsContentProvider(EObject context, IStructuredContentProvider encapsulated, String extension) {
        if (context.eResource() != null) {
            this.encapsulatedRS = context.eResource().getResourceSet();
        } else {
            Activator.log.debug("RoboticsContentProvider: passed context is not contained in a resource (proxy?)");
        }
        this.encapsulated = encapsulated;
        this.extension = extension;
        this.tempRS = new ResourceSetImpl();
    }

    protected Object[] getTopElements() {
        Object[] top = new String[]{MODEL_MATCHES, MODELS_VIA_PATHMAPS, WORKSPACE_MATCHES};
        return top;
    }

    public Object[] getElements(Object parent) {
        ArrayList<URI> results = new ArrayList<URI>();
        List<URI> availableURIs = null;
        if (parent.equals(EMPTY)) {
            return this.getTopElements();
        }
        if (parent == MODEL_MATCHES) {
            return super.getElements((Object)EMPTY);
        }
        if (parent == WORKSPACE_MATCHES) {
            availableURIs = ScanUtils.modelURIsInWorkspace(this.extension);
            results.addAll(availableURIs);
        } else if (parent == MODELS_VIA_PATHMAPS) {
            availableURIs = ScanUtils.pathmapsWithModels(this.extension);
            results.addAll(availableURIs);
        }
        return results.toArray();
    }

    protected boolean containsStereotype(Resource r) {
        for (EObject obj : r.getContents()) {
            if (!this.stereotypeFilter.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public ResourceSet getResourceSet() {
        return this.encapsulatedRS;
    }

    public Object[] getElements() {
        ArrayList<Object> results = new ArrayList<Object>();
        Object[] objectArray = super.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof EObjectTreeElement) {
                obj = ((EObjectTreeElement)obj).getEObject();
            }
            results.add(obj);
            ++n2;
        }
        results.addAll(ScanUtils.modelURIsInWorkspace(this.extension));
        results.addAll(ScanUtils.allPathmapModels(this.extension));
        return results.toArray();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof String) {
            return this.getElements(element).length > 0;
        }
        if (element instanceof URI) {
            URI uri = (URI)element;
            if (uri.path().endsWith(this.extension)) {
                Resource r = this.tempRS.getResource((URI)element, true);
                return this.containsStereotype(r);
            }
            return true;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof String) {
            return this.getElements(parentElement);
        }
        if (parentElement instanceof URI) {
            URI uri = (URI)parentElement;
            if (uri.segmentCount() > 0 && uri.segment(0).length() > 0) {
                Resource r = this.tempRS.getResource(uri, true);
                Package subRoot = (Package)r.getContents().get(0);
                return this.getChildren(subRoot);
            }
            return ScanUtils.modelsFromPath(uri, this.extension).toArray();
        }
        if (this.encapsulated instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)this.encapsulated).getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (this.encapsulated instanceof ITreeContentProvider) {
            Object parent = ((ITreeContentProvider)this.encapsulated).getParent(element);
            if (parent == null && element instanceof EObjectTreeElement) {
                return MODEL_MATCHES;
            }
            return parent;
        }
        return null;
    }
}

