/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.commands;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.architecture.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.robotics.core.Activator;
import org.eclipse.papyrus.robotics.profile.util.RoboticsResource;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateRoboticsModelCommand
implements IModelCreationCommand {
    private static final String TEMPLATE_URI = "platform:/plugin/org.eclipse.papyrus.robotics.core/templates/robmosys-model.uml";

    public void createModel(ModelSet modelSet) {
        this.runAsTransaction(modelSet);
    }

    protected void runAsTransaction(ModelSet modelSet) {
        final Resource modelResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
        URI origURI = modelResource.getURI();
        try {
            try {
                modelResource.setURI(URI.createURI((String)TEMPLATE_URI));
                modelResource.load(null);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
                AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Initialize model", Collections.EMPTY_LIST){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        EObject model = CreateRoboticsModelCommand.this.getRootElement(modelResource);
                        CreateRoboticsModelCommand.this.attachModelToResource(model, modelResource);
                        CreateRoboticsModelCommand.this.initializeModel(model);
                        return CommandResult.newOKCommandResult();
                    }
                };
                editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
                modelResource.setURI(origURI);
            }
        }
        finally {
            modelResource.setURI(origURI);
        }
    }

    protected EObject getRootElement(Resource modelResource) {
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0) {
            Object root = modelResource.getContents().get(0);
            if (root instanceof EObject) {
                rootElement = (EObject)root;
            }
        } else {
            rootElement = this.createRootElement();
        }
        return rootElement;
    }

    protected EObject createRootElement() {
        return UMLFactory.eINSTANCE.createModel();
    }

    protected void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    protected void initializeModel(EObject owner) {
        ((Package)owner).setName(this.getModelName());
        Profile profile = (Profile)PackageUtil.loadPackage((URI)URI.createURI((String)"pathmap://ROBOTICS_BPC_PROFILES/bpc.profile.uml"), (ResourceSet)owner.eResource().getResourceSet());
        if (profile != null) {
            PackageUtil.applyProfile((Package)((Package)owner), (Profile)profile, (boolean)true);
        } else {
            Activator.log.error("Impossible to find BPC profile", null);
        }
        profile = (Profile)PackageUtil.loadPackage((URI)RoboticsResource.PROFILE_PATH_URI, (ResourceSet)owner.eResource().getResourceSet());
        if (profile != null) {
            PackageUtil.applyProfile((Package)((Package)owner), (Profile)profile, (boolean)true);
        } else {
            Activator.log.error("Impossible to find RobMoSys profile", null);
        }
    }

    protected String getModelName() {
        return "RobMoSysModel";
    }
}

