/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.robotics.bt.profile.bt.TreeRoot;
import org.eclipse.papyrus.robotics.bt.ui.Activator;
import org.eclipse.papyrus.robotics.bt.xsdgw.uml2xml.executors.BTMLToBehaviortreeSchemaTransformExecutor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class BTMLToBehaviortreeSchemaTransformExecutorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            final IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        Object[] objectArray = structuredSelection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object current = objectArray[n2];
                            if (current instanceof IAdaptable) {
                                EObject eObj = (EObject)((IAdaptable)current).getAdapter(EObject.class);
                                TreeRoot tr = (TreeRoot)UMLUtil.getStereotypeApplication((Element)((Element)eObj), TreeRoot.class);
                                URI modelURI = URI.createURI((String)tr.getBase_Activity().getModel().eResource().getURI().trimFileExtension().toString()).appendFileExtension("di");
                                IFile model = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(modelURI.toPlatformString(true)));
                                BTMLToBehaviortreeSchemaTransformExecutor.run((Activity)tr.getBase_Activity());
                                model.getProject().refreshLocal(2, monitor);
                            }
                            ++n2;
                        }
                    }
                    catch (ExecutionException | CoreException e) {
                        Status status = new Status(4, "org.eclipse.papyrus.robotics.bt.ui", e.getMessage(), e);
                        Activator.getDefault().getLog().log((IStatus)status);
                        Display.getDefault().asyncExec(new Runnable((IStatus)status){
                            private final /* synthetic */ IStatus val$status;
                            {
                                this.val$status = iStatus;
                            }

                            @Override
                            public void run() {
                                String errMsg = "Unable to export the P4R BT model to a XML model conforming to BehaviorTree.CPP XSD";
                                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)errMsg, (IStatus)this.val$status);
                            }
                        });
                        return;
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.eclipse.papyrus.robotics.bt.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "org.eclipse.papyrus.robotics.bt.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }
}

