/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.component;

import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ManualGeneration;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.utils.Helpers;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.xtend2.lib.StringConcatenation;

public class CreateMain {
    public static CharSequence registerComponent(Class component) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"rclcpp_components/register_node_macro.hpp\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// Register the component with class_loader.");
        _builder.newLine();
        _builder.append("// This acts as a sort of entry point, allowing the component to be discoverable when its library");
        _builder.newLine();
        _builder.append("// is being loaded into a running process.");
        _builder.newLine();
        _builder.append("RCLCPP_COMPONENTS_REGISTER_NODE(");
        String _qualifiedName = component.getQualifiedName();
        _builder.append(_qualifiedName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static void createMain(Class component) {
        Package _nearestPackage = component.getNearestPackage();
        String _name = component.getName();
        String _plus = String.valueOf(_name) + "_main";
        Class main = _nearestPackage.createOwnedClass(_plus, false);
        component.createDependency((NamedElement)main);
        StereotypeUtil.apply((Element)main, ManualGeneration.class);
        Include include = (Include)StereotypeUtil.applyApp((Element)main, Include.class);
        include.setBody(CreateMain.createMainCode(component).toString());
    }

    public static CharSequence createMainCode(Class component) {
        int _size;
        boolean _greaterThan_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        String _instName = CreateMain.getInstName(component);
        String instRef = String.valueOf(_instName) + "->";
        _builder.newLineIfNotEmpty();
        CharSequence onActivate = CreateMain.onActivate(component, instRef);
        _builder.newLineIfNotEmpty();
        String _qualifiedName = component.getQualifiedName();
        String _postfix = ActivityUtils.getPostfix(component);
        String compClassName = String.valueOf(_qualifiedName) + _postfix;
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _name = component.getNearestPackage().getName();
        _builder.append(_name);
        _builder.append("/");
        String _name_1 = component.getName();
        _builder.append(_name_1);
        String _postfix_1 = ActivityUtils.getPostfix(component);
        _builder.append(_postfix_1);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _hasPeriodicActivities = ActivityUtils.hasPeriodicActivities(component);
        if (_hasPeriodicActivities) {
            _builder.append("using namespace std::chrono_literals;");
            _builder.newLine();
        }
        CreateMain.createTimer(component);
        _builder.newLineIfNotEmpty();
        _builder.append("// declare options");
        _builder.newLine();
        _builder.append("rclcpp::NodeOptions ");
        String _instName_1 = CreateMain.getInstName(component);
        _builder.append(_instName_1);
        _builder.append("_options;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("int main(int argc, char **argv) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rclcpp::init(argc, argv);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("auto ");
        String _instName_2 = CreateMain.getInstName(component);
        _builder.append(_instName_2, "\t");
        _builder.append(" = std::make_shared<");
        _builder.append(compClassName, "\t");
        _builder.append(">(");
        String _instName_3 = CreateMain.getInstName(component);
        _builder.append(_instName_3, "\t");
        _builder.append("_options);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("RCLCPP_INFO(");
        _builder.append(instRef, "\t");
        _builder.append("get_logger(), \"");
        String _name_2 = component.getName();
        _builder.append(_name_2, "\t");
        _builder.append(" has been initialized\");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        int _length = onActivate.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("register_on_activate(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append((Object)onActivate, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(");");
            _builder.newLine();
        }
        boolean bl2 = _greaterThan_1 = (_size = ParameterUtils.getAllParameters((Class)component).size()) > 0;
        if (_greaterThan_1) {
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("declareParameters();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(instRef, "\t");
            _builder.append("initParameterVars();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rclcpp::executors::MultiThreadedExecutor executor;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("executor.add_node(");
        _builder.append(instRef, "\t");
        _builder.append("get_node_base_interface());");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("executor.spin();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rclcpp::shutdown();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static void createTimer(Class component) {
        boolean _greaterThan;
        int _size = ActivityUtils.functionsToActivate(component).size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)component, (String)"ros2Library::rclcpp::timer::TimerBase");
            Type timerBase = (Type)_qualifiedElementFromRS;
            Property timer = component.createOwnedAttribute("timer_", timerBase);
            Helpers.useSharedPtr((TypedElement)timer);
        }
    }

    public static CharSequence onActivate(Class component, String instRef) {
        StringConcatenation _builder = new StringConcatenation();
        UniqueEList<Activity> _functionsToActivate = ActivityUtils.functionsToActivate(component);
        for (Activity activity : _functionsToActivate) {
            String period = ActivityUtils.getPeriod(activity);
            _builder.newLineIfNotEmpty();
            Behavior activateFct = FunctionUtils.getFunction((Activity)activity, (FunctionKind)FunctionKind.ON_ACTIVATE);
            _builder.newLineIfNotEmpty();
            Behavior periodicFct = FunctionUtils.getFunction((Activity)activity, (FunctionKind)FunctionKind.PERIODIC);
            _builder.newLineIfNotEmpty();
            _builder.append("[");
            String _instName = CreateMain.getInstName(component);
            _builder.append(_instName);
            _builder.append("](const rclcpp_lifecycle::State&) {");
            _builder.newLineIfNotEmpty();
            if (activateFct != null) {
                _builder.append("\t");
                _builder.append(instRef, "\t");
                String _name = activateFct.getName();
                _builder.append(_name, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            if (period != null && periodicFct != null) {
                _builder.append("\t");
                _builder.append("// periodic execution (");
                _builder.append(period, "\t");
                _builder.append(") using a wall timer");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append(instRef, "\t");
                _builder.append("timer_ = ");
                _builder.append(instRef, "\t");
                _builder.append("create_wall_timer(");
                _builder.append(period, "\t");
                _builder.append(",");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("std::bind(&");
                String _name_1 = component.getNearestPackage().getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("::");
                String _name_2 = component.getName();
                _builder.append(_name_2, "\t\t");
                String _postfix = ActivityUtils.getPostfix(component);
                _builder.append(_postfix, "\t\t");
                _builder.append("::");
                String _name_3 = periodicFct.getName();
                _builder.append(_name_3, "\t\t");
                _builder.append(", ");
                String _instName_1 = CreateMain.getInstName(component);
                _builder.append(_instName_1, "\t\t");
                _builder.append("));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("return rclcpp_lifecycle::node_interfaces::LifecycleNodeInterface::CallbackReturn::SUCCESS;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public static String getInstName(Class component) {
        return component.getName().toLowerCase();
    }
}

