/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.verificationandvalidationconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VV_MethodKind implements Enumerator
{
    ANALYSIS(0, "Analysis", "Analysis"),
    INSPECTION(1, "Inspection", "Inspection"),
    SYSTEM_TEST(2, "SystemTest", "SystemTest"),
    COMPONENT_TEST(3, "ComponentTest", "ComponentTest");

    public static final int ANALYSIS_VALUE = 0;
    public static final int INSPECTION_VALUE = 1;
    public static final int SYSTEM_TEST_VALUE = 2;
    public static final int COMPONENT_TEST_VALUE = 3;
    private static final VV_MethodKind[] VALUES_ARRAY;
    public static final List<VV_MethodKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VV_MethodKind[]{ANALYSIS, INSPECTION, SYSTEM_TEST, COMPONENT_TEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VV_MethodKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VV_MethodKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VV_MethodKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VV_MethodKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VV_MethodKind get(int value) {
        switch (value) {
            case 0: {
                return ANALYSIS;
            }
            case 1: {
                return INSPECTION;
            }
            case 2: {
                return SYSTEM_TEST;
            }
            case 3: {
                return COMPONENT_TEST;
            }
        }
        return null;
    }

    private VV_MethodKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

