/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import org.eclipse.papyrus.moka.pssm.statemachines.IStateActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateConfiguration;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateMachineConfiguration;
import org.eclipse.papyrus.moka.pssm.statemachines.IStateMachineExecution;
import org.eclipse.papyrus.moka.pssm.statemachines.IVertexActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.StateConfiguration;

public class StateMachineConfiguration
implements IStateMachineConfiguration {
    protected IStateMachineExecution execution;
    protected IStateConfiguration rootConfiguration = new StateConfiguration(this);

    public IStateConfiguration getRoot() {
        return this.rootConfiguration;
    }

    public IStateMachineExecution getExecution() {
        return this.execution;
    }

    public StateMachineConfiguration(IStateMachineExecution execution) {
        this.execution = execution;
    }

    public boolean register(IStateActivation stateActivation) {
        boolean added = this.rootConfiguration.addChild((IVertexActivation)stateActivation);
        return added;
    }

    public boolean unregister(IStateActivation stateActivation) {
        boolean removed = this.rootConfiguration.removeChild((IVertexActivation)stateActivation);
        if (removed) {
            stateActivation.releaseDeferredEvents();
        }
        return removed;
    }

    public boolean isActive(IVertexActivation activation) {
        return this.rootConfiguration.isConfigurationFor(activation);
    }

    public String toString() {
        return "[" + this.rootConfiguration.toString() + "]";
    }
}

