/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.process;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.papyrus.moka.kernel.process.MokaProcessStatus;

public abstract class BaseProcess<ProcessType>
implements IProcess {
    private static final String MOKA_PROCESS_NAME = "Moka Process";
    protected MokaProcessStatus status = MokaProcessStatus.NONE;
    protected ReentrantLock statusLock = new ReentrantLock(true);
    protected ILaunch launch;
    protected ProcessType process;
    protected Map<String, String> attributes;

    public BaseProcess(ILaunch l) {
        this.launch = l;
        this.process = null;
        this.attributes = new HashMap<String, String>();
    }

    protected void setStatus(MokaProcessStatus s) {
        this.statusLock.lock();
        this.status = s;
        this.statusLock.unlock();
    }

    protected MokaProcessStatus getStatus() {
        MokaProcessStatus s = null;
        this.statusLock.lock();
        s = this.status;
        this.statusLock.unlock();
        return s;
    }

    public ProcessType getProcess() {
        return this.process;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getLabel() {
        return MOKA_PROCESS_NAME;
    }

    public void setAttribute(String key, String value) {
        if (key != null && !key.isEmpty()) {
            this.attributes.put(key, value);
        }
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public abstract void run();
}

