/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.messages.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.moka.debug.messages.DebugEventContextKind;
import org.eclipse.papyrus.moka.debug.messages.DebugRequest;
import org.eclipse.papyrus.moka.debug.messages.MessagesFactory;
import org.eclipse.papyrus.moka.debug.messages.MessagesPackage;
import org.eclipse.papyrus.moka.debug.messages.ThreadRequest;
import org.eclipse.papyrus.moka.debug.messages.impl.DebugRequestImpl;
import org.eclipse.papyrus.moka.debug.messages.impl.ThreadRequestImpl;

public class MessagesFactoryImpl
extends EFactoryImpl
implements MessagesFactory {
    public static MessagesFactory init() {
        try {
            MessagesFactory theMessagesFactory = (MessagesFactory)EPackage.Registry.INSTANCE.getEFactory("Debug");
            if (theMessagesFactory != null) {
                return theMessagesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MessagesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createThreadRequest();
            }
            case 1: {
                return this.createDebugRequest();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createDebugEventContextKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertDebugEventContextKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ThreadRequest createThreadRequest() {
        ThreadRequestImpl threadRequest = new ThreadRequestImpl();
        return threadRequest;
    }

    @Override
    public DebugRequest createDebugRequest() {
        DebugRequestImpl debugRequest = new DebugRequestImpl();
        return debugRequest;
    }

    public DebugEventContextKind createDebugEventContextKindFromString(EDataType eDataType, String initialValue) {
        DebugEventContextKind result = DebugEventContextKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDebugEventContextKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public MessagesPackage getMessagesPackage() {
        return (MessagesPackage)this.getEPackage();
    }

    @Deprecated
    public static MessagesPackage getPackage() {
        return MessagesPackage.eINSTANCE;
    }
}

