/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.commonbehavior;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IParameterValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.Object_;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public abstract class Execution
extends Object_
implements IExecution {
    public IObject_ context;
    public List<IParameterValue> parameterValues = new ArrayList<IParameterValue>();

    public abstract void execute();

    public void terminate() {
    }

    @Override
    public IValue copy() {
        IExecution newValue = (IExecution)super.copy();
        newValue.setContext(this.getContext());
        List<IParameterValue> parameterValues = this.getParameterValues();
        int i = 0;
        while (i < parameterValues.size()) {
            IParameterValue parameterValue = parameterValues.get(i);
            newValue.getParameterValues().add(parameterValue.copy());
            ++i;
        }
        return newValue;
    }

    @Override
    public abstract IValue new_();

    public void setParameterValue(IParameterValue parameterValue) {
        IParameterValue existingParameterValue = this.getParameterValue(parameterValue.getParameter());
        if (existingParameterValue == null) {
            this.getParameterValues().add(parameterValue);
        } else {
            existingParameterValue.setValues(parameterValue.getValues());
        }
    }

    public IParameterValue getReturnParameterValue() {
        IParameterValue value = null;
        int i = 0;
        while (value == null && i < this.getParameterValues().size()) {
            Parameter parameter = this.getParameterValues().get(i).getParameter();
            if (parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                value = this.getParameterValues().get(i);
            }
            ++i;
        }
        return value;
    }

    public IParameterValue getParameterValue(Parameter parameter) {
        IParameterValue parameterValue = null;
        int i = 1;
        while (parameterValue == null & i <= this.getParameterValues().size()) {
            if (this.getParameterValues().get(i - 1).getParameter() == parameter) {
                parameterValue = this.getParameterValues().get(i - 1);
            }
            ++i;
        }
        return parameterValue;
    }

    public List<IParameterValue> getOutputParameterValues() {
        ArrayList<IParameterValue> outputs = new ArrayList<IParameterValue>();
        List<IParameterValue> parameterValues = this.getParameterValues();
        int i = 0;
        while (i < parameterValues.size()) {
            IParameterValue parameterValue = parameterValues.get(i);
            Parameter parameter = parameterValue.getParameter();
            if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.OUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                outputs.add(parameterValue);
            }
            ++i;
        }
        return outputs;
    }

    public Behavior getBehavior() {
        return (Behavior)this.getTypes().get(0);
    }

    public void setContext(IObject_ context) {
        this.context = context;
    }

    public IObject_ getContext() {
        return this.context;
    }

    public List<IParameterValue> getParameterValues() {
        return this.parameterValues;
    }
}

