/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;

public class MokaExecutionEngineJob
extends Job {
    protected IExecutionEngine engine;
    protected EObject executionEntryPoint;
    protected boolean isCanceling = false;
    protected String[] executionArgs;
    protected IProgressMonitor monitor;
    protected ILaunch launch;
    protected static MokaExecutionEngineJob ENGINE_MAIN_JOB;

    private MokaExecutionEngineJob() {
        super(MokaConstants.EXECUTION_ENGINE_JOB_NAME);
    }

    public static MokaExecutionEngineJob getInstance() {
        if (ENGINE_MAIN_JOB == null) {
            ENGINE_MAIN_JOB = new MokaExecutionEngineJob();
        }
        return ENGINE_MAIN_JOB;
    }

    public boolean isCanceling() {
        return this.isCanceling;
    }

    protected void canceling() {
        this.isCanceling = true;
        super.canceling();
    }

    public void initialize(ILaunch launch, IExecutionEngine engine, EObject executionEntryPoint, String[] executionArgs) {
        this.launch = launch;
        this.engine = engine;
        this.executionEntryPoint = executionEntryPoint;
        this.executionArgs = executionArgs;
        this.addJobChangeListener(new MokaExecutionEngineSpy());
    }

    protected IStatus run(IProgressMonitor monitor) {
        Status jobStatus = new Status(0, "org.eclipse.papyrus.moka", "Execution was successfull");
        this.monitor = monitor;
        this.engine.init(this.launch, this.executionEntryPoint, this.executionArgs, IExecutionEngine.OperatingMode.NORMAL);
        try {
            this.engine.start(monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            jobStatus = new Status(8, "org.eclipse.papyrus.moka", "Execution stopped by user request");
        }
        catch (Exception e) {
            jobStatus = monitor.isCanceled() ? new Status(8, "org.eclipse.papyrus.moka", "Execution stopped by user request") : new Status(4, "org.eclipse.papyrus.moka", "Execution stopped: unexpected exception", (Throwable)e);
        }
        return jobStatus;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public IExecutionEngine getEngine() {
        return this.engine;
    }

    class MokaExecutionEngineSpy
    implements IJobChangeListener {
        MokaExecutionEngineSpy() {
        }

        public void done(IJobChangeEvent event) {
            ENGINE_MAIN_JOB = null;
            StopJob stop = new StopJob(MokaExecutionEngineJob.this.engine);
            stop.setUser(true);
            stop.schedule(20L);
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }

        public void scheduled(IJobChangeEvent event) {
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }

    class StopJob
    extends Job {
        protected IExecutionEngine engine;

        public StopJob(IExecutionEngine engine) {
            super("Release execution engine resources");
            this.engine = engine;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block5: {
                monitor.beginTask("Dispose execution engine resources...", -1);
                try {
                    try {
                        this.engine.stop(monitor);
                    }
                    catch (Exception exception) {
                        monitor.done();
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return new Status(0, "org.eclipse.papyrus.moka", "Resources release with success");
        }
    }
}

