/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.engine;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;

public class MokaProcess
implements IProcess {
    protected HashMap<String, String> attributes = new HashMap();
    protected ILaunch launch;
    protected Job executionEngineJob;
    private IStatus jobStatus;

    public MokaProcess(ILaunch launch, Job executionEngineJob) {
        this.launch = launch;
        this.jobStatus = null;
        this.executionEngineJob = executionEngineJob;
    }

    public void schedule(int priority) {
        this.executionEngineJob.setName(MokaConstants.EXECUTION_ENGINE_JOB_NAME);
        this.executionEngineJob.setPriority(priority);
        this.executionEngineJob.schedule();
    }

    public boolean canTerminate() {
        return this.launch.getDebugTarget() == null && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.jobStatus != null && this.jobStatus.getSeverity() == 0 | this.jobStatus.getSeverity() == 8 | this.jobStatus.getSeverity() == 4;
    }

    public void terminate() throws DebugException {
        if (this.executionEngineJob != null) {
            if (!this.executionEngineJob.cancel()) {
                try {
                    this.executionEngineJob.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.jobStatus = this.executionEngineJob.getResult();
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        }
    }

    public String getLabel() {
        return "Moka process";
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.jobStatus.getSeverity();
        }
        throw new DebugException((IStatus)new Status(4, "org.eclipse.papyrus.moka.debug", "Moka execution process is still running"));
    }

    public void setAttribute(String key, String value) {
        String keyValue = this.attributes.get(key);
        if (keyValue != null) {
            if (!value.equals(keyValue)) {
                keyValue = value;
            }
        } else {
            this.attributes.put(key, value);
        }
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }
}

