/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IAxisListener;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphListener;
import org.eclipse.papyrus.moka.xygraph.mapping.util.BaseAxisListener;
import org.eclipse.papyrus.moka.xygraph.mapping.util.TraceDataBounds;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.ModelWritingStrategyFactory;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.AxisDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphPackage;

public class XYGraphCoordinator {
    protected XYGraphBinder graphMap;
    protected ModelWritingStrategyFactory factory;
    private List<XYGraphListener> listeners = new ArrayList<XYGraphListener>();

    public XYGraphCoordinator(XYGraphBinder binder, ModelWritingStrategyFactory factory) {
        this.graphMap = binder;
        this.factory = factory;
    }

    public void updateDescriptors(XYGraph xy) {
        this.factory.getXYGraphUpdateStrategy().updateXYGraph(xy, this.graphMap);
        for (Axis axis : this.graphMap.getAxes()) {
            this.factory.getAxisUpdateStrategy().updateAxisDescriptor(axis, this.graphMap);
        }
        for (Trace trace : this.graphMap.getTraces()) {
            this.factory.getTraceUpdateStrategy().updateTraceDescriptor(trace, this.graphMap);
        }
        this.onXYGraphUpdated();
    }

    protected void onXYGraphUpdated() {
        this.fireXYGraphUpdated(this.graphMap.getXYGraphDescriptor());
    }

    public IXYGraph buildXYGraph() {
        this.factory.getAxisBuildStrategy().rebuildAxes(this.graphMap);
        IXYGraph xy = this.factory.getXYGraphBuildStrategy().buildGraph(this.graphMap);
        XYGraphDescriptor gDesc = this.graphMap.getXYGraphDescriptor();
        for (AxisDescriptor aDesc : gDesc.getAxisDescriptors()) {
            Axis axis = this.graphMap.getAxisFor(aDesc);
            axis.addListener((IAxisListener)new BaseAxisListener(){

                @Override
                public void axisRangeChanged(Axis axis, Range old_range, Range new_range) {
                    XYGraphCoordinator.this.onAxisRangeChanged(axis, old_range, new_range);
                }
            });
            if (this.graphMap.isPrimary(aDesc)) continue;
            xy.addAxis(axis);
        }
        this.factory.getTraceBuildStrategy().rebuildTraces(this.graphMap);
        for (TraceDescriptor tDesc : gDesc.getTraceDescriptors()) {
            xy.addTrace(this.graphMap.getTraceFor(tDesc));
        }
        this.onXYGraphBuilt();
        return xy;
    }

    protected void onXYGraphBuilt() {
        this.fireXYGraphBuilt(this.graphMap.getXYGraphDescriptor());
    }

    public XYGraphDescriptor getXYGraphDescriptor() {
        return this.graphMap.getXYGraphDescriptor();
    }

    public void addXYGraphListener(XYGraphListener listener) {
        this.listeners.add(listener);
    }

    protected void fireXYGraphUpdated(XYGraphDescriptor xyGraph) {
        for (XYGraphListener listener : this.listeners) {
            listener.onXYGraphUpdated(this, xyGraph);
        }
    }

    protected void fireXYGraphBuilt(XYGraphDescriptor xyGraph) {
        for (XYGraphListener listener : this.listeners) {
            listener.onXYGraphBuilt(this, xyGraph);
        }
    }

    public void synchronizeTracesVisibility() {
        XYGraphDescriptor xyDesc = this.graphMap.getXYGraphDescriptor();
        EList visibles = xyDesc.getVisibleTraces();
        this.factory.getTraceBuildStrategy().rebuildTraces(this.graphMap);
        for (TraceDescriptor tDesc : this.graphMap.getTraceDescriptors()) {
            if (visibles.contains(tDesc)) {
                this.showTrace(this.graphMap.getXYGraph(), this.graphMap.getTraceFor(tDesc));
                continue;
            }
            this.hideTrace(this.graphMap.getXYGraph(), this.graphMap.getTraceFor(tDesc));
        }
    }

    protected void addNewTrace(TraceDescriptor tDesc, boolean visible) {
        XYGraphDescriptor xy = this.graphMap.getXYGraphDescriptor();
        xy.getTraceDescriptors().add((Object)tDesc);
        this.factory.getTraceBuildStrategy().rebuildTraces(this.graphMap);
        if (visible) {
            xy.getVisibleTraces().add((Object)tDesc);
            this.showTrace(this.graphMap.getXYGraph(), this.graphMap.getTraceFor(tDesc));
        }
    }

    protected void removeTrace(TraceDescriptor tDesc) {
        XYGraphDescriptor xy = this.graphMap.getXYGraphDescriptor();
        xy.getVisibleTraces().remove((Object)tDesc);
        Trace trace = this.graphMap.unbindTrace(tDesc);
        this.hideTrace(this.graphMap.getXYGraph(), trace);
    }

    private void hideTrace(XYGraph graph, Trace trace) {
        if (graph.getPlotArea().getChildren().contains(trace)) {
            graph.removeTrace(trace);
        }
    }

    private void showTrace(XYGraph graph, Trace trace) {
        if (!graph.getPlotArea().getChildren().contains(trace)) {
            graph.addTrace(trace);
        }
    }

    public void onModelUpdate(Notification notification) {
        if (XYGraphPackage.eINSTANCE.getXYGraphDescriptor_VisibleTraces().equals(notification.getFeature())) {
            this.synchronizeTracesVisibility();
        }
        if (XYGraphPackage.eINSTANCE.getXYGraphDescriptor_Title().equals(notification.getFeature())) {
            this.graphMap.getXYGraph().setTitle(notification.getNewStringValue());
        }
    }

    protected void onAxisRangeChanged(Axis axis, Range old_range, Range new_range) {
        AxisDescriptor aDesc = this.graphMap.getDescriptorFor(axis);
        this.factory.getAxisUpdateStrategy().updateAxisDescriptor(axis, this.graphMap);
        System.out.println("Updated axis Range: " + aDesc.getRangeLower() + ", " + aDesc.getRangeUpper());
    }

    public void dispose() {
        this.graphMap.dispose();
    }

    public void rescaleAxesIfNeeded() {
        AxisDescriptor xPrimary = this.graphMap.getDescriptorFor(this.graphMap.getXAxisPrimary());
        AxisDescriptor yPrimary = this.graphMap.getDescriptorFor(this.graphMap.getYAxisPrimary());
        if (xPrimary.getRangeLower() < xPrimary.getRangeUpper() && yPrimary.getRangeLower() < yPrimary.getRangeUpper()) {
            return;
        }
        this.forceAxesRescale();
    }

    public void forceAxesRescale() {
        TraceDataBounds dataBounds = new TraceDataBounds();
        for (TraceDescriptor tDesc : this.graphMap.getTraceDescriptors()) {
            dataBounds.union(this.graphMap.getTraceDataBounds(tDesc));
        }
        this.graphMap.getXAxisPrimary().setRange(dataBounds.getxMin(), dataBounds.getxMax());
        this.graphMap.getYAxisPrimary().setRange(dataBounds.getyMin(), dataBounds.getyMax());
        this.factory.getAxisUpdateStrategy().updateAxisDescriptor(this.graphMap.getXAxisPrimary(), this.graphMap);
        this.factory.getAxisUpdateStrategy().updateAxisDescriptor(this.graphMap.getYAxisPrimary(), this.graphMap);
    }
}

