/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.ArchiveToUnzipInFMU;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.FmumetamodelFactory;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.FolderToCreateInFMU;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.JavaFileProxy;

public class FMUResourceUtil {
    public static final String MODEL_DESCRIPTION_FILE_NAME = "modelDescription.xml";
    public static final String FOLDER_RESOURCES = "resources";
    public static final String FOLDER_DOCUMENTATION = "documentation";
    public static final String FOLDER_SOURCES = "sources";
    public static final String FOLDER_BINARIES = "binaries";
    public static final String BINARIES_WIN32 = "win32";
    public static final String BINARIES_WIN64 = "win64";
    public static final String BINARIES_LINUX32 = "linux32";
    public static final String BINARIES_LINUX64 = "linux64";
    public static final String BINARIES_DARWIN32 = "darwin32";
    public static final String BINARIES_DARWIN64 = "darwin64";
    public static final URI MODEL_DESCRIPTION_ZIP_URI = URI.createURI((String)"fmi:/fmuTmp");

    public static Collection<? extends JavaFileProxy> createJavaFileProxies(File[] listFiles) {
        ArrayList<JavaFileProxy> ret = new ArrayList<JavaFileProxy>();
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ret.add(FMUResourceUtil.createJavaFileProxy(file));
            ++n2;
        }
        return ret;
    }

    public static JavaFileProxy createJavaFileProxy(File file) {
        return FMUResourceUtil.createJavaFileProxy(file, null);
    }

    public static JavaFileProxy createJavaFileProxy(File file, String newName) {
        JavaFileProxy ret = FmumetamodelFactory.eINSTANCE.createJavaFileProxy();
        if (newName != null) {
            ret.setName(newName);
        }
        ret.setFile(file);
        return ret;
    }

    public static ArchiveToUnzipInFMU createArchiveToUnzipInFMU(File archiveFile, String newName) {
        ArchiveToUnzipInFMU ret = FmumetamodelFactory.eINSTANCE.createArchiveToUnzipInFMU();
        ret.setArchiveFile(archiveFile);
        if (newName != null) {
            ret.setName(newName);
        }
        return ret;
    }

    public static ArchiveToUnzipInFMU createArchiveToUnzipInFMU(File archiveFile) {
        return FMUResourceUtil.createArchiveToUnzipInFMU(archiveFile, null);
    }

    public static FolderToCreateInFMU createFolderToCreateInFMU(String folderName) {
        FolderToCreateInFMU ret = FmumetamodelFactory.eINSTANCE.createFolderToCreateInFMU();
        ret.setName(folderName);
        return ret;
    }

    public static boolean isAStandardFile(File fmuChildFile) {
        String name = fmuChildFile.getName();
        return MODEL_DESCRIPTION_FILE_NAME.equals(name) || !FOLDER_BINARIES.equals(name) || !FOLDER_DOCUMENTATION.equals(name) || !FOLDER_RESOURCES.equals(name) || !FOLDER_SOURCES.equals(name);
    }
}

