/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.fmu;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.papyrus.moka.fmi.fmu.FMUParser;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.AbstractFile;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.ArchiveToUnzipInFMU;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.FMUBundle;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.FmumetamodelFactory;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.FolderToCreateInFMU;
import org.eclipse.papyrus.moka.fmi.fmumetamodel.JavaFileProxy;
import org.eclipse.papyrus.moka.fmi.modeldescription.DocumentRoot;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiFactory;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiModelDescriptionType;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiPackage;
import org.eclipse.papyrus.moka.fmi.modeldescription.util.FmiResourceImpl;
import org.eclipse.papyrus.moka.fmi.util.FMUResourceUtil;
import org.eclipse.papyrus.moka.fmi.util.UnzipUtility;

public class FMUResource
extends XMLResourceImpl {
    FMUParser fmuParser;
    FMUBundle fmuBundle;

    public FMUParser getFmuParser() {
        return this.fmuParser;
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        Path tmpDirectoryPath = Files.createTempDirectory("fmuResource", new FileAttribute[0]);
        UnzipUtility.unzip(new ZipInputStream(inputStream), tmpDirectoryPath.toString());
        this.fmuParser = new FMUParser(tmpDirectoryPath.toString());
        this.createFmuBundle();
        this.getContents().add((Object)this.fmuBundle);
    }

    private void createFmuBundle() throws IOException {
        this.fmuBundle = FmumetamodelFactory.eINSTANCE.createFMUBundle();
        if (this.fmuParser.getModelDescription() != null) {
            this.fmuBundle.setModelDescription(this.fmuParser.getModelDescription());
        }
        File fmuFolder = this.fmuParser.getFMUFolder();
        File[] fileArray = fmuFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fmuChildFile = fileArray[n2];
            switch (fmuChildFile.getName()) {
                case "resources": {
                    this.fmuBundle.getResourcesFiles().addAll(FMUResourceUtil.createJavaFileProxies(fmuChildFile.listFiles()));
                    break;
                }
                case "documentation": {
                    this.fmuBundle.getDocumentationFiles().addAll(FMUResourceUtil.createJavaFileProxies(fmuChildFile.listFiles()));
                    break;
                }
                case "sources": {
                    this.fmuBundle.getDocumentationFiles().addAll(FMUResourceUtil.createJavaFileProxies(fmuChildFile.listFiles()));
                    break;
                }
                case "binaries": {
                    File[] fileArray2 = fmuChildFile.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File fmuGrandChildFile = fileArray2[n4];
                        switch (fmuGrandChildFile.getName()) {
                            case "win32": {
                                this.fmuBundle.getWin32Files().addAll(FMUResourceUtil.createJavaFileProxies(fmuGrandChildFile.listFiles()));
                                break;
                            }
                            case "win64": {
                                this.fmuBundle.getWin64Files().addAll(FMUResourceUtil.createJavaFileProxies(fmuGrandChildFile.listFiles()));
                                break;
                            }
                            case "linux32": {
                                this.fmuBundle.getLinux32Files().addAll(FMUResourceUtil.createJavaFileProxies(fmuGrandChildFile.listFiles()));
                                break;
                            }
                            case "linux64": {
                                this.fmuBundle.getLinux64Files().addAll(FMUResourceUtil.createJavaFileProxies(fmuGrandChildFile.listFiles()));
                                break;
                            }
                            case "darwin32": {
                                this.fmuBundle.getDarwin32Files().addAll(FMUResourceUtil.createJavaFileProxies(fmuGrandChildFile.listFiles()));
                                break;
                            }
                            case "darwin64": {
                                this.fmuBundle.getDarwin64Files().addAll(FMUResourceUtil.createJavaFileProxies(fmuGrandChildFile.listFiles()));
                                break;
                            }
                            default: {
                                this.fmuBundle.getRootFiles().add((Object)FMUResourceUtil.createJavaFileProxy(fmuGrandChildFile, "binaries/" + fmuGrandChildFile.getName()));
                            }
                        }
                        ++n4;
                    }
                }
                default: {
                    if (FMUResourceUtil.isAStandardFile(fmuChildFile)) break;
                    this.fmuBundle.getRootFiles().add((Object)FMUResourceUtil.createJavaFileProxy(fmuChildFile));
                }
            }
            ++n2;
        }
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (!(this.getContents().get(0) instanceof FMUBundle)) {
            throw new IOException("The content of the FMUResource should be a FMUBundle");
        }
        this.fmuBundle = (FMUBundle)this.getContents().get(0);
        ZipOutputStream zipOputputStream = new ZipOutputStream(outputStream);
        this.saveModelDescription(zipOputputStream);
        this.saveBinaries(zipOputputStream);
        this.saveResources(zipOputputStream);
        this.saveDocumentation(zipOputputStream);
        this.saveRoot(zipOputputStream);
        zipOputputStream.close();
    }

    private void saveModelDescription(ZipOutputStream zipOutputStream) throws IOException {
        if (this.fmuBundle.getModelDescription() != null) {
            FmiResourceImpl modelDescRes = new FmiResourceImpl(null);
            FmiModelDescriptionType modelDesc = (FmiModelDescriptionType)EcoreUtil.copy((EObject)this.fmuBundle.getModelDescription());
            DocumentRoot root = FmiFactory.eINSTANCE.createDocumentRoot();
            root.setFmiModelDescription(modelDesc);
            modelDescRes.getContents().add((Object)root);
            BasicExtendedMetaData exMet = new BasicExtendedMetaData();
            exMet.setQualified((EPackage)FmiPackage.eINSTANCE, false);
            HashMap<String, Object> saveOptions = new HashMap<String, Object>();
            saveOptions.put("EXTENDED_META_DATA", exMet);
            saveOptions.put("ENCODING", "utf-8");
            StringWriter stringWriter = new StringWriter();
            modelDescRes.save(stringWriter, saveOptions);
            ZipEntry modelDescEntry = new ZipEntry("modelDescription.xml");
            zipOutputStream.putNextEntry(modelDescEntry);
            zipOutputStream.write(stringWriter.getBuffer().toString().getBytes());
            zipOutputStream.closeEntry();
        }
    }

    private void saveBinaries(ZipOutputStream zipOputputStream) throws IOException {
        this.addFiles((List<AbstractFile>)this.fmuBundle.getWin32Files(), zipOputputStream, "binaries/win32");
        this.addFiles((List<AbstractFile>)this.fmuBundle.getWin64Files(), zipOputputStream, "binaries/win64");
        this.addFiles((List<AbstractFile>)this.fmuBundle.getLinux32Files(), zipOputputStream, "binaries/linux32");
        this.addFiles((List<AbstractFile>)this.fmuBundle.getLinux64Files(), zipOputputStream, "binaries/linux64");
        this.addFiles((List<AbstractFile>)this.fmuBundle.getDarwin32Files(), zipOputputStream, "binaries/darwin32");
        this.addFiles((List<AbstractFile>)this.fmuBundle.getDarwin64Files(), zipOputputStream, "binaries/darwin64");
    }

    private void saveRoot(ZipOutputStream zipOutputStream) throws IOException {
        this.addFiles((List<AbstractFile>)this.fmuBundle.getRootFiles(), zipOutputStream, ".");
    }

    private void saveDocumentation(ZipOutputStream zipOutputStream) throws IOException {
        this.addFiles((List<AbstractFile>)this.fmuBundle.getDocumentationFiles(), zipOutputStream, "documentation");
    }

    private void saveResources(ZipOutputStream zipOutputStream) throws IOException {
        this.addFiles((List<AbstractFile>)this.fmuBundle.getResourcesFiles(), zipOutputStream, "resources");
    }

    private void addFile(AbstractFile fmuFile, ZipOutputStream zipOutputStream, String fmuFolder) throws IOException {
        if (fmuFile instanceof JavaFileProxy && ((JavaFileProxy)fmuFile).getFile() != null && ((JavaFileProxy)fmuFile).getFile().exists()) {
            this.addEntry(((JavaFileProxy)fmuFile).getFile(), zipOutputStream, fmuFolder, fmuFile.getName());
        } else if (fmuFile instanceof FolderToCreateInFMU) {
            FolderToCreateInFMU folderToCreate = (FolderToCreateInFMU)fmuFile;
            if (folderToCreate.getChildren().isEmpty()) {
                this.createEmptyDir(zipOutputStream, String.valueOf(fmuFolder) + "/" + folderToCreate.getName());
            } else {
                for (AbstractFile childFile : folderToCreate.getChildren()) {
                    this.addFile(childFile, zipOutputStream, String.valueOf(fmuFolder) + "/" + folderToCreate.getName());
                }
            }
        } else if (fmuFile instanceof ArchiveToUnzipInFMU) {
            this.unzipArchiveFile((ArchiveToUnzipInFMU)fmuFile, zipOutputStream, fmuFolder);
        }
    }

    private void addFiles(List<AbstractFile> fmuFiles, ZipOutputStream zipOutputStream, String fmuFolder) throws IOException {
        for (AbstractFile fmuFile : fmuFiles) {
            this.addFile(fmuFile, zipOutputStream, fmuFolder);
        }
    }

    private void unzipArchiveFile(ArchiveToUnzipInFMU archiveToAdd, ZipOutputStream zipOutputStream, String fmuFolder) throws IOException {
        if (archiveToAdd.getArchiveFile() != null && archiveToAdd.getArchiveFile().exists()) {
            String rootName = fmuFolder;
            Throwable throwable = null;
            Object var6_7 = null;
            try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(archiveToAdd.getArchiveFile()));){
                ZipEntry entryToCopy;
                if (archiveToAdd.getName() != null) {
                    rootName = String.valueOf(fmuFolder) + "/" + archiveToAdd.getName();
                }
                while ((entryToCopy = zipIn.getNextEntry()) != null) {
                    int len;
                    ZipEntry newEntry = new ZipEntry(String.valueOf(rootName) + "/" + entryToCopy.getName());
                    zipOutputStream.putNextEntry(newEntry);
                    byte[] buffer = new byte[1024];
                    while ((len = zipIn.read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, len);
                    }
                    zipOutputStream.closeEntry();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void createEmptyDir(ZipOutputStream zipOutputStream, String entryName) throws IOException {
        ZipEntry emptyDirEntry = new ZipEntry(String.valueOf(entryName) + "/");
        zipOutputStream.putNextEntry(emptyDirEntry);
        zipOutputStream.closeEntry();
    }

    private void addEntry(File file, ZipOutputStream zipOutputStream, String fmuFolder, String entryName) throws IOException {
        String name;
        String string = name = entryName != null ? entryName : file.getName();
        if (file.isDirectory()) {
            if (file.listFiles().length == 0) {
                this.createEmptyDir(zipOutputStream, String.valueOf(fmuFolder) + "/" + name);
            }
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.addEntry(child, zipOutputStream, String.valueOf(fmuFolder) + "/" + name, null);
                ++n2;
            }
        } else {
            ZipEntry fileEntry = new ZipEntry(String.valueOf(fmuFolder) + "/" + name);
            Throwable throwable = null;
            Object var8_9 = null;
            try (FileInputStream in = new FileInputStream(file);){
                int len;
                zipOutputStream.putNextEntry(fileEntry);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
                zipOutputStream.closeEntry();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected void doUnload() {
        super.doUnload();
        if (this.fmuParser != null) {
            this.fmuParser.clean();
            this.fmuParser = null;
        }
    }
}

