/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.moka.fmi.fmiprofile.FlowDirection;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.uml.diagram.composite.custom.edit.command.CreateViewCommand;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class DropFMUAsPartCommand
extends AbstractTransactionalCommand {
    protected static final int PORT_DEFAULT_HEIGHT = 20;
    protected static final int WIDTH_FACTOR = 11;
    protected static final int MIN_WIDTH = 150;
    protected static final int MIN_HEIGHT = 150;
    protected static final double X_FONT_HEIGHT_FACTOR = 0.9;
    protected static final double Y_FONT_HEIGHT_FACTOR = 0.85;
    protected static final double X_WEST_OFFSET = 8.0;
    protected static final int Y_LABEL_OFFSET = 20;
    protected Class targetSimulator;
    protected Class sourceType;
    protected DropObjectsRequest request;
    protected Property newPart;
    protected GraphicalEditPart targetGraphicalEditPart;
    protected View targetView;
    protected TransactionalEditingDomain domain;

    public DropFMUAsPartCommand(DropObjectsRequest request, TransactionalEditingDomain domain, Class containerClass, Class sourceType, GraphicalEditPart targetEditPart, View targetView) {
        super(domain, "Create a composite part from FMU and create graphical view", DropFMUAsPartCommand.getWorkspaceFiles((EObject)containerClass));
        this.targetSimulator = containerClass;
        this.sourceType = sourceType;
        this.request = request;
        this.targetGraphicalEditPart = targetEditPart;
        this.targetView = targetView;
        this.domain = domain;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createNewPart();
        this.createGraphicalViews();
        this.request.setResult((Object)this.newPart);
        return CommandResult.newOKCommandResult((Object)this.newPart);
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return super.doUndo(monitor, info);
    }

    protected void createNewPart() {
        String partName = this.sourceType.getName();
        this.newPart = this.targetSimulator.createOwnedAttribute(partName, (Type)this.sourceType);
        this.newPart.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)partName, (Collection)this.targetSimulator.getOwnedAttributes()));
        this.newPart.setAggregation(AggregationKind.COMPOSITE_LITERAL);
    }

    protected void createGraphicalViews() {
        List<Port> inPorts = this.collectPorts(this.newPart, FlowDirection.IN);
        List<Port> outPorts = this.collectPorts(this.newPart, FlowDirection.OUT);
        outPorts.addAll(this.collectPorts(this.newPart, FlowDirection.INOUT));
        int figureWidth = Math.max(150, 11 * this.newPart.getName().length());
        int maxPortOnOneSide = Math.max(inPorts.size(), outPorts.size());
        int figureHeight = Math.max(150, (2 * maxPortOnOneSide + 1) * 20);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)this.newPart), Node.class, ((IHintedType)UMLElementTypes.getElementType((String)UMLVisualIDRegistry.getNodeVisualID((View)this.targetView, (EObject)this.newPart))).getSemanticHint(), this.targetGraphicalEditPart.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.domain, descriptor, this.targetView);
        try {
            createCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        Point location = this.request.getLocation().getCopy();
        this.targetGraphicalEditPart.getContentPane().translateToRelative((Translatable)location);
        Dimension dimension = new Dimension(figureWidth, figureHeight);
        Rectangle partRectangle = new Rectangle(location, dimension);
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.domain, "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), partRectangle);
        try {
            setBoundsCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.createPorts(inPorts, outPorts, partRectangle, (IAdaptable)createCommand.getCommandResult().getReturnValue());
    }

    private void createPorts(List<Port> inPorts, List<Port> outPorts, Rectangle rectangle, IAdaptable figureAdapter) {
        Point proposedLocation;
        Port port;
        View view = (View)figureAdapter.getAdapter(View.class);
        int index = 0;
        while (index < inPorts.size()) {
            port = inPorts.get(index);
            proposedLocation = new Point(0, (index + 1) * rectangle.height / (inPorts.size() + 1));
            this.createPortView(port, proposedLocation, view, PositionKind.EAST);
            ++index;
        }
        index = 0;
        while (index < outPorts.size()) {
            port = outPorts.get(index);
            proposedLocation = new Point(rectangle.width, (index + 1) * rectangle.height / (outPorts.size() + 1));
            this.createPortView(port, proposedLocation, view, PositionKind.WEST);
            ++index;
        }
    }

    private void createPortView(Port port, Point location, View view, PositionKind position) {
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)port), Node.class, ((IHintedType)UMLElementTypes.getElementType((String)UMLVisualIDRegistry.getNodeVisualID((View)view, (EObject)port))).getSemanticHint(), this.targetGraphicalEditPart.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.domain, descriptor, view);
        try {
            createCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.domain, "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), location);
        try {
            setBoundsCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private List<Port> collectPorts(Property newPart, FlowDirection direction) {
        ArrayList<Port> ret = new ArrayList<Port>();
        Class partType = (Class)newPart.getType();
        for (Port port : partType.getOwnedPorts()) {
            if (direction != FMIProfileUtil.getDirection((Port)port)) continue;
            ret.add(port);
        }
        return ret;
    }

    static enum PositionKind {
        EAST,
        WEST;

    }
}

