/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.presentation.control;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimatingInstanceNode;
import org.eclipse.swt.widgets.Composite;

public class AnimationEditingSupport
extends EditingSupport {
    private TreeViewer viewer;
    private ComboBoxCellEditor cellEditor;
    public static final String YES = "Yes";
    public static final String NO = "No";

    public AnimationEditingSupport(TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        this.viewer = treeViewer;
        this.cellEditor = new ComboBoxCellEditor((Composite)treeViewer.getControl(), new String[]{YES, NO});
        this.cellEditor.setStyle(0x1000000);
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof AnimatingInstanceNode) {
            return this.cellEditor;
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return element instanceof AnimatingInstanceNode;
    }

    protected Object getValue(Object element) {
        if (element instanceof AnimatingInstanceNode) {
            if (((AnimatingInstanceNode)element).isAllowed()) {
                return 0;
            }
            return 1;
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof AnimatingInstanceNode) {
            if ((Integer)value == 0) {
                ((AnimatingInstanceNode)element).setAllowed(true);
            } else {
                ((AnimatingInstanceNode)element).setAllowed(false);
            }
            this.viewer.update(element, null);
        }
    }
}

